/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.ledgers.composite;

import io.intino.sumus.engine.AbstractAttribute;
import io.intino.sumus.engine.Attribute;
import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Fact;
import io.intino.sumus.engine.Filter;
import io.intino.sumus.engine.Index;
import io.intino.sumus.engine.Ledger;
import io.intino.sumus.engine.Lookup;
import io.intino.sumus.engine.builders.CubeBuilder;
import io.intino.sumus.engine.dimensions.DayDimension;
import io.intino.sumus.engine.dimensions.DayOfWeekDimension;
import io.intino.sumus.engine.dimensions.MonthOfYearDimension;
import io.intino.sumus.engine.dimensions.YearDimension;
import io.intino.sumus.engine.ledgers.columnar.Column;
import io.intino.sumus.engine.ledgers.composite.CompositeDimension;
import io.intino.sumus.model.AttributeDefinition;
import io.intino.sumus.model.LedgerDefinition;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CompositeLedger
implements Ledger {
    private final String name;
    private int size;
    private final List<Attribute> attributes;
    private final List<Dimension> dimensions;
    private final List<LocalDate> dates;
    private final List<Ledger> ledgers;

    public CompositeLedger(String name) {
        this.name = name;
        this.size = 0;
        this.attributes = new ArrayList<Attribute>();
        this.dimensions = new ArrayList<Dimension>();
        this.dates = new ArrayList<LocalDate>();
        this.ledgers = new ArrayList<Ledger>();
    }

    @Override
    public LedgerDefinition definition() {
        return this.ledgers.stream().findFirst().map(Ledger::definition).orElse(null);
    }

    private Attribute dateAttribute(String name) {
        return new CompositeAttribute((AttributeDefinition)new AttributeDefinition.Date(name));
    }

    public CompositeLedger add(Ledger ledger, LocalDate date) {
        if (this.ledgers.isEmpty() || ledger.definition() == this.definition()) {
            this.dates.add(date);
            this.ledgers.add(ledger);
        }
        return this;
    }

    @Override
    public Ledger.Query cube() {
        return new Ledger.Query(){
            private Filter filter = Filter.None;
            private List<Dimension> dimensions = Collections.emptyList();

            @Override
            public Ledger.Query filter(Filter filter) {
                this.filter = filter;
                return this;
            }

            @Override
            public Ledger.Query dimensions(List<Dimension> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            @Override
            public Cube build() {
                return new CubeBuilder((Ledger)CompositeLedger.this, this.filter, this.dimensions).build();
            }
        };
    }

    @Override
    public Iterable<Fact> facts(Filter filter) {
        return () -> new CompositeFactIterator(filter);
    }

    @Override
    public List<Column> columns(String name) {
        return this.ledgers.stream().flatMap(l -> l.columns(name).stream()).collect(Collectors.toList());
    }

    @Override
    public int size() {
        if (this.size == 0) {
            this.size = this.ledgers.stream().mapToInt(Ledger::size).sum();
        }
        return this.size;
    }

    @Override
    public List<Attribute> attributes() {
        if (this.attributes.isEmpty()) {
            this.attributes.add(this.dateAttribute(this.name));
            this.attributes.addAll(this.ledgers.get(0).attributes());
        }
        return this.attributes;
    }

    @Override
    public List<Dimension> dimensions() {
        this.loadDimensions();
        return this.dimensions;
    }

    @Override
    public Dimension dimension(String name) {
        return Ledger.super.dimension(name);
    }

    private void loadDimensions() {
        if (this.dimensions.isEmpty()) {
            this.dimensions.addAll(this.dateDimensions());
            this.dimensions.addAll(this.compositeDimensions(this.offsets()));
        }
    }

    private int[] offsets() {
        int[] offsets = new int[this.ledgers.size()];
        for (int i = 1; i < offsets.length; ++i) {
            offsets[i] = offsets[i - 1] + this.ledgers.get(i - 1).size();
        }
        return offsets;
    }

    private List<Dimension> compositeDimensions(int[] offsets) {
        return CompositeLedger.groupDimensionsOf(this.ledgers).stream().map(d -> new CompositeDimension((List<Dimension>)d, offsets)).collect(Collectors.toList());
    }

    private static Collection<List<Dimension>> groupDimensionsOf(List<Ledger> ledgers) {
        return ledgers.stream().flatMap(c -> c.dimensions().stream()).collect(Collectors.groupingBy(Dimension::name)).values();
    }

    private List<Dimension> dateDimensions() {
        Lookup lookup = this.lookup();
        return this.dateDimensionsOf(lookup);
    }

    private Lookup lookup() {
        return new Lookup(){

            @Override
            public String name() {
                return CompositeLedger.this.name;
            }

            @Override
            public AttributeDefinition.Type type() {
                return AttributeDefinition.Type.date;
            }

            @Override
            public boolean hasNA() {
                return false;
            }

            @Override
            public Stream<?> uniques() {
                return Stream.empty();
            }

            @Override
            public Object min() {
                return CompositeLedger.this.dates.stream().mapToLong(LocalDate::toEpochDay).min().orElse(Long.MAX_VALUE);
            }

            @Override
            public Object max() {
                return CompositeLedger.this.dates.stream().mapToLong(LocalDate::toEpochDay).max().orElse(Long.MIN_VALUE);
            }

            @Override
            public Index createIndex(final Predicate<Object> predicate) {
                return new Index(){

                    @Override
                    public boolean accepts(int idx) {
                        return predicate.test(this.date(idx));
                    }

                    private long date(int idx) {
                        int sum = 0;
                        for (int i = 0; i < CompositeLedger.this.ledgers.size(); ++i) {
                            if (idx >= (sum += CompositeLedger.this.ledgers.get(i).size())) continue;
                            return CompositeLedger.this.dates.get(i).toEpochDay();
                        }
                        return Long.MIN_VALUE;
                    }
                };
            }
        };
    }

    private List<Dimension> dateDimensionsOf(Lookup lookup) {
        return List.of(new DayOfWeekDimension(lookup), new MonthOfYearDimension(lookup), new YearDimension(lookup), new DayDimension(lookup));
    }

    public class CompositeAttribute
    extends AbstractAttribute {
        public CompositeAttribute(AttributeDefinition definition) {
            super(definition);
        }

        @Override
        public AttributeDefinition definition() {
            return this.definition;
        }

        @Override
        protected LedgerDefinition ledgerDefinition() {
            return CompositeLedger.this.definition();
        }
    }

    private class CompositeFactIterator
    implements Iterator<Fact> {
        private int idx = 0;
        private final Filter filter;
        private Fact fact;
        private LocalDate date;
        private final Iterator<Ledger> cubeIterator;
        private final Iterator<LocalDate> dateIterator;
        private Iterator<Fact> factIterator;

        public CompositeFactIterator(Filter filter) {
            this.cubeIterator = CompositeLedger.this.ledgers.iterator();
            this.dateIterator = CompositeLedger.this.dates.iterator();
            this.factIterator = Collections.emptyIterator();
            this.filter = filter;
            this.fact = this.nextFact();
        }

        @Override
        public boolean hasNext() {
            return this.fact != null;
        }

        @Override
        public Fact next() {
            Fact result = this.fact;
            this.fact = this.nextFact();
            return result;
        }

        private Fact nextFact() {
            while (this.idx < CompositeLedger.this.size()) {
                Fact cubeFact = this.nextCubeFact();
                if (!this.filter.accepts(this.idx++)) continue;
                return this.wrap(this.idx - 1, cubeFact);
            }
            return null;
        }

        private Fact nextCubeFact() {
            while (!this.factIterator.hasNext()) {
                if (!this.cubeIterator.hasNext()) {
                    return null;
                }
                this.date = this.dateIterator.next();
                this.factIterator = this.cubeIterator.next().facts().iterator();
            }
            return this.factIterator.next();
        }

        private Fact wrap(final int id, final Fact fact) {
            return new Fact(){

                @Override
                public int idx() {
                    return id;
                }

                @Override
                public List<Attribute> attributes() {
                    return CompositeLedger.this.attributes;
                }

                @Override
                public Object value(String attribute) {
                    return attribute.equals(CompositeLedger.this.name) ? CompositeFactIterator.this.date : fact.value(attribute);
                }

                public String toString() {
                    return CompositeLedger.this.name + ":" + CompositeFactIterator.this.date.toString() + "," + fact.toString();
                }
            };
        }
    }
}

