/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.ledgers.columnar;

import io.intino.sumus.engine.AbstractAttribute;
import io.intino.sumus.engine.Attribute;
import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Fact;
import io.intino.sumus.engine.Filter;
import io.intino.sumus.engine.Ledger;
import io.intino.sumus.engine.SumusEngine;
import io.intino.sumus.engine.builders.CubeBuilder;
import io.intino.sumus.engine.dimensions.CategoricalDimension;
import io.intino.sumus.engine.dimensions.DayOfWeekDimension;
import io.intino.sumus.engine.dimensions.MonthOfYearDimension;
import io.intino.sumus.engine.dimensions.NumericalDimension;
import io.intino.sumus.engine.dimensions.YearDimension;
import io.intino.sumus.engine.io.TsvLedgerReader;
import io.intino.sumus.engine.ledgers.columnar.Column;
import io.intino.sumus.engine.ledgers.columnar.columns.DataColumn;
import io.intino.sumus.model.AttributeDefinition;
import io.intino.sumus.model.DimensionDefinition;
import io.intino.sumus.model.LedgerDefinition;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ColumnarLedger
implements Ledger {
    public final LedgerDefinition definition;
    public final List<Column> columns;
    public final List<Dimension> dimensions;
    private final Map<String, Column> columnMap = new HashMap<String, Column>();
    private int size;

    public ColumnarLedger(LedgerDefinition definition) {
        this.definition = definition;
        this.columns = new ArrayList<Column>(definition.attributes.size());
        this.dimensions = new ArrayList<Dimension>(definition.attributes.size());
    }

    @Override
    public LedgerDefinition definition() {
        return this.definition;
    }

    public ColumnarLedger load(File file, String separator) throws IOException {
        return this.load(this.read(file, separator));
    }

    public ColumnarLedger load(String[][] data) {
        this.loadingWith(this.transpose(data));
        return this;
    }

    private void loadingWith(String[][] data) {
        ExecutorService threadPool = SumusEngine.createThreadPool();
        for (int i = 0; i < this.definition.attributes.size(); ++i) {
            Attribute attribute = this.attributeOf(i);
            String[] values = data[i];
            threadPool.execute(() -> this.add(new DataColumn(attribute, values)));
        }
        this.waitFor(threadPool);
        this.sortColumnList();
    }

    private void waitFor(ExecutorService threadPool) {
        try {
            threadPool.shutdown();
            threadPool.awaitTermination(SumusEngine.TIMEOUT_AMOUNT.get(), SumusEngine.TIMEOUT_UNIT.get());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void sortColumnList() {
        this.columns.clear();
        for (AttributeDefinition attrib : this.definition.attributes) {
            this.columns.add(this.column(attrib.name()));
        }
    }

    private String[][] read(File file, String separator) throws IOException {
        return TsvLedgerReader.read(file, separator);
    }

    private Attribute attributeOf(int i) {
        return new ColumnarAttribute((AttributeDefinition)this.definition.attributes.get(i));
    }

    private String[][] transpose(String[][] rows) {
        String[][] columns = this.initColumns(rows.length);
        for (int i = 0; i < rows.length; ++i) {
            String[] row = rows[i];
            for (int j = 0; j < row.length; ++j) {
                columns[j][i] = row[j];
            }
        }
        return columns;
    }

    private String[][] initColumns(int size) {
        return new String[this.definition.attributes.size()][size];
    }

    public synchronized ColumnarLedger add(Column column) {
        if (column == null) {
            return this;
        }
        if (this.columnMap.isEmpty()) {
            this.size = column.size();
        }
        this.columns.add(column);
        this.dimensions.addAll(this.dimensionsOf(column));
        this.columnMap.put(column.name(), column);
        return this;
    }

    public void removeColumnIf(Predicate<Column> condition) {
        List columnsToRemove = this.columns.stream().filter(condition).collect(Collectors.toList());
        for (Column column : columnsToRemove) {
            this.columns.remove(column);
            this.columnMap.remove(column.name());
        }
    }

    private List<Dimension> dimensionsOf(Column column) {
        if (column.type() == AttributeDefinition.Type.category) {
            return this.categoricalDimensionsOf(column);
        }
        if (column.type() == AttributeDefinition.Type.date) {
            return this.dateDimensionsOf(column);
        }
        if (column.type().isNumeric()) {
            return this.numericDimensionsOf(column);
        }
        return Collections.emptyList();
    }

    private List<Dimension> categoricalDimensionsOf(Column column) {
        return List.of(new CategoricalDimension(column));
    }

    private List<Dimension> dateDimensionsOf(Column column) {
        return List.of(new YearDimension(column), new MonthOfYearDimension(column), new DayOfWeekDimension(column));
    }

    private List<Dimension> numericDimensionsOf(Column column) {
        return Arrays.stream(column.attribute().dimensions()).map(d -> this.dimension(column, (DimensionDefinition)d)).collect(Collectors.toList());
    }

    private Dimension dimension(Column column, DimensionDefinition definition) {
        return new NumericalDimension(column, definition.name(), definition.classifier());
    }

    @Override
    public Ledger.Query cube() {
        return new Ledger.Query(){
            private List<Dimension> dimensions = Collections.emptyList();
            private Filter filter = Filter.None;

            @Override
            public Ledger.Query filter(Filter filter) {
                this.filter = filter;
                return this;
            }

            @Override
            public Ledger.Query dimensions(List<Dimension> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            @Override
            public Cube build() {
                return new CubeBuilder((Ledger)ColumnarLedger.this, this.filter, this.dimensions).build();
            }
        };
    }

    public Fact fact(int idx) {
        return new ColumnarFact(idx);
    }

    @Override
    public Iterable<Fact> facts(Filter filter) {
        return () -> new FactIterator(filter);
    }

    @Override
    public List<Column> columns(String name) {
        return List.of(this.column(name));
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public List<Attribute> attributes() {
        return this.columns.stream().map(Column::attribute).collect(Collectors.toList());
    }

    @Override
    public List<Dimension> dimensions() {
        return this.dimensions;
    }

    public Column column(String name) {
        return this.columnMap.getOrDefault(name, Column.Null);
    }

    public class ColumnarAttribute
    extends AbstractAttribute {
        public ColumnarAttribute(AttributeDefinition definition) {
            super(definition);
        }

        @Override
        public AttributeDefinition definition() {
            return this.definition;
        }

        @Override
        protected LedgerDefinition ledgerDefinition() {
            return ColumnarLedger.this.definition;
        }
    }

    private class ColumnarFact
    implements Fact {
        private final int idx;
        private final Map<String, Object> values = new HashMap<String, Object>(this.attributes().size());

        public ColumnarFact(int idx) {
            this.idx = idx;
            for (Attribute attribute : this.attributes()) {
                this.values.put(attribute.name(), ColumnarLedger.this.column(attribute.name()).value(idx));
            }
        }

        @Override
        public int idx() {
            return this.idx;
        }

        @Override
        public List<Attribute> attributes() {
            return ColumnarLedger.this.attributes();
        }

        @Override
        public Object value(String attribute) {
            return this.values.get(attribute);
        }

        public String toString() {
            return this.attributes().stream().map(a -> a.name() + ":" + this.format(this.value(a.name()))).collect(Collectors.joining(","));
        }

        private Object format(Object value) {
            return value == null ? "" : value.toString();
        }
    }

    private class FactIterator
    implements Iterator<Fact> {
        private final Filter filter;
        private int idx = 0;
        private Fact fact;

        public FactIterator(Filter filter) {
            this.filter = filter;
            this.fact = this.nextFact();
        }

        @Override
        public boolean hasNext() {
            return this.fact != null;
        }

        @Override
        public Fact next() {
            Fact result = this.fact;
            this.fact = this.nextFact();
            return result;
        }

        private Fact nextFact() {
            while (this.idx < ColumnarLedger.this.size) {
                if (!this.filter.accepts(this.idx++)) continue;
                return this.fact(this.idx - 1);
            }
            return null;
        }

        private Fact fact(int idx) {
            return new ColumnarFact(idx);
        }
    }
}

