/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.filters;

import io.intino.sumus.engine.Filter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class CompositeFilter
implements Filter {
    private final List<Filter> filters;

    public static Filter of(Filter ... filters) {
        if (filters.length == 0) {
            return None;
        }
        if (filters.length == 1) {
            return filters[0];
        }
        if (CompositeFilter.anyIsAll(filters)) {
            return All;
        }
        return new CompositeFilter(filters);
    }

    static boolean anyIsAll(Filter ... filters) {
        return Arrays.stream(filters).anyMatch(f -> f == All);
    }

    private CompositeFilter(Filter ... filters) {
        this.filters = Arrays.stream(filters).filter(f -> f != Filter.None).collect(Collectors.toList());
    }

    @Override
    public boolean accepts(int idx) {
        for (Filter f : this.filters) {
            if (f.accepts(idx)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.filters.stream().map(Object::toString).collect(Collectors.joining(" | "));
    }
}

