/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.builders.accumulators;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.builders.accumulators.BuilderAccumulator;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;

public class DateAccumulator
extends BuilderAccumulator {
    private final int[] count;
    private final long[] min;
    private final long[] max;

    public DateAccumulator(String name) {
        super(name);
        this.count = new int[this.threadCount];
        this.min = new long[this.threadCount];
        this.max = new long[this.threadCount];
        Arrays.fill(this.min, Long.MAX_VALUE);
        Arrays.fill(this.max, Long.MIN_VALUE);
    }

    @Override
    public void add(Object value) {
        int t;
        if (value == null) {
            return;
        }
        int n = t = this.threadIndex();
        this.count[n] = this.count[n] + 1;
        this.min[t] = Math.min(this.min[t], (Long)value);
        this.max[t] = Math.max(this.max[t], (Long)value);
    }

    @Override
    public List<Cube.Indicator> indicators() {
        long count = Arrays.stream(this.count).sum();
        long min = Arrays.stream(this.min).min().orElse(Long.MAX_VALUE);
        long max = Arrays.stream(this.max).max().orElse(Long.MIN_VALUE);
        return List.of(Cube.indicator("count(" + this.name + ")", count), Cube.indicator("min(" + this.name + ")", this.minDate(min)), Cube.indicator("max(" + this.name + ")", this.maxDate(max)));
    }

    private LocalDate minDate(long min) {
        return min == Long.MAX_VALUE ? LocalDate.MAX : LocalDate.ofEpochDay(min);
    }

    private LocalDate maxDate(long max) {
        return max == Long.MIN_VALUE ? LocalDate.MIN : LocalDate.ofEpochDay(max);
    }
}

