/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.builders;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Fact;
import io.intino.sumus.engine.Filter;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.engine.builders.Accumulator;
import io.intino.sumus.engine.filters.SliceFilter;
import io.intino.sumus.model.IndicatorDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CellBuilder {
    private final List<IndicatorDefinition> indicators;
    private final Filter filter;
    private final List<Slice> slices;
    private Accumulator[] accumulators = new Accumulator[0];

    public CellBuilder(List<IndicatorDefinition> indicators) {
        this.indicators = indicators;
        this.filter = Filter.None;
        this.slices = Collections.emptyList();
    }

    public CellBuilder(List<IndicatorDefinition> indicators, List<Slice> slices) {
        this.indicators = indicators;
        this.filter = SliceFilter.of(slices);
        this.slices = slices;
    }

    public void setAccumulators(Accumulator[] accumulators) {
        this.accumulators = accumulators;
    }

    public void add(Fact fact) {
        boolean isAccepted = this.filter.accepts(fact.idx());
        for (Accumulator accumulator : this.accumulators) {
            Object value = fact.value(accumulator.name());
            accumulator.addTotal(value);
            if (!isAccepted) continue;
            accumulator.add(value);
        }
    }

    public String toString() {
        return this.slices.stream().map(Slice::name).collect(Collectors.joining("-"));
    }

    public Cube.Cell cell(Iterable<Fact> facts) {
        return new CellImpl(facts);
    }

    public List<Slice> slices() {
        return this.slices;
    }

    public List<IndicatorDefinition> indicators() {
        return this.indicators;
    }

    public Filter filter() {
        return this.filter;
    }

    public Accumulator[] accumulators() {
        return this.accumulators;
    }

    public class CellImpl
    implements Cube.Cell {
        private Map<String, Cube.Indicator> indicatorValueMap;
        private final Iterable<Fact> facts;

        public CellImpl(Iterable<Fact> facts) {
            this.facts = facts;
        }

        public List<Accumulator> accumulators() {
            return Arrays.asList(CellBuilder.this.accumulators);
        }

        @Override
        public List<? extends Slice> slices() {
            return CellBuilder.this.slices;
        }

        @Override
        public List<? extends Cube.Indicator> indicators() {
            return new ArrayList<Cube.Indicator>(this.indicatorsMap().values());
        }

        @Override
        public Map<String, ? extends Cube.Indicator> indicatorsMap() {
            if (this.indicatorValueMap == null) {
                this.indicatorValueMap = this.translate(this.calculations());
            }
            return this.indicatorValueMap;
        }

        private Map<String, Cube.Indicator> translate(Map<String, Cube.Indicator> calculations) {
            return CellBuilder.this.indicators.stream().map(d -> this.indicator(calculations, (IndicatorDefinition)d)).collect(Collectors.toMap(Cube.Indicator::name, i -> i));
        }

        private Cube.Indicator indicator(Map<String, Cube.Indicator> calculations, IndicatorDefinition d) {
            return calculations.getOrDefault(d.label(), Cube.Indicator.None).as(d.name(), d.unit(), this.ratio(d.scale()));
        }

        private double ratio(IndicatorDefinition.Scale scale) {
            return scale == null ? 1.0 : scale.ratio();
        }

        private Map<String, Cube.Indicator> calculations() {
            return Arrays.stream(CellBuilder.this.accumulators).flatMap(a -> a.indicators().stream()).collect(Collectors.toMap(Cube.Indicator::name, i -> i, (a, b) -> a));
        }

        @Override
        public Iterable<Fact> facts() {
            return this.facts;
        }

        public String toString() {
            return CellBuilder.this.slices.stream().map(Object::toString).collect(Collectors.joining("-"));
        }
    }
}

