/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine;

import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Index;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public interface Slice {
    default public Slice parent() {
        return null;
    }

    public String name();

    public Dimension dimension();

    default public int level() {
        return 1;
    }

    public boolean isNA();

    public Index index();

    public static class SliceIndex
    implements Index {
        private final Index index;

        public SliceIndex(Set<Slice> slices) {
            this.index = this.groupedByDimension(slices);
        }

        @Override
        public boolean accepts(int idx) {
            return this.index.accepts(idx);
        }

        private Index groupedByDimension(Set<Slice> slices) {
            Collection<List<Slice>> slicesByDimension = slices.stream().collect(Collectors.groupingBy(Slice::dimension)).values();
            Index[] indices = new Index[slicesByDimension.size()];
            int i = 0;
            for (List<Slice> sliceList : slicesByDimension) {
                indices[i++] = sliceList.stream().map(Slice::index).filter(Objects::nonNull).reduce(Index::or).orElse(Index.None);
            }
            return Arrays.stream(indices).reduce(Index::and).orElse(Index.None);
        }
    }
}

