/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine;

import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Fact;
import io.intino.sumus.engine.Filter;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.engine.filters.SliceFilter;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public interface Cube {
    public List<? extends Dimension> dimensions();

    default public List<Slice> slices() {
        return this.cells().stream().flatMap(c -> c.slices().stream()).distinct().collect(Collectors.toList());
    }

    public List<? extends Cell> cells();

    public Map<String, ? extends Cell> cellMap();

    default public List<Cell> cells(Predicate<Cell> predicate) {
        return this.cells().stream().filter(predicate).collect(Collectors.toList());
    }

    default public Cell cell(String name) {
        return this.cellMap().get(name);
    }

    public Iterable<Fact> facts(Filter var1);

    default public Iterable<Fact> facts(Slice ... slices) {
        return this.facts(SliceFilter.of(slices));
    }

    default public Iterable<Fact> facts() {
        return this.facts(Filter.None);
    }

    public static Object ratio(Object value, double ratio) {
        if (value instanceof Integer) {
            return (double)((Integer)value).intValue() * ratio;
        }
        if (value instanceof Long) {
            return (double)((Long)value).longValue() * ratio;
        }
        if (value instanceof Double) {
            return (Double)value * ratio;
        }
        return value;
    }

    public static Indicator indicator(String name, Object value) {
        return Cube.indicator(name, value, "");
    }

    public static Indicator indicator(final String name, final Object value, final String units) {
        return new Indicator(){

            @Override
            public String name() {
                return name;
            }

            @Override
            public Object value() {
                return value;
            }

            @Override
            public String units() {
                return units;
            }

            public String toString() {
                return name;
            }
        };
    }

    public static interface Indicator {
        public static final Indicator None = Cube.indicator("", 0);

        public String name();

        public Object value();

        public String units();

        default public Indicator as(String name, String units, double ratio) {
            return ratio == 1.0 ? Cube.indicator(name, this.value(), units) : Cube.indicator(name, Cube.ratio(this.value(), ratio), units);
        }
    }

    public static interface Cell {
        public List<? extends Slice> slices();

        public List<? extends Indicator> indicators();

        public Map<String, ? extends Indicator> indicatorsMap();

        default public Indicator indicator(String name) {
            return this.indicatorsMap().get(name);
        }

        public Iterable<Fact> facts();
    }
}

