/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine;

import io.intino.sumus.model.AttributeDefinition;
import io.intino.sumus.model.DimensionDefinition;

public interface Attribute {
    public static final Attribute Null = new NullAttribute();

    public AttributeDefinition definition();

    public boolean isUsedInIndicators();

    public DimensionDefinition[] dimensions();

    default public String name() {
        return this.definition().name();
    }

    default public boolean isNumeric() {
        return this.definition().isNumeric();
    }

    default public AttributeDefinition.Type type() {
        return this.definition().type();
    }

    public static class NullAttribute
    implements Attribute {
        @Override
        public AttributeDefinition definition() {
            return new AttributeDefinition.Label("");
        }

        @Override
        public boolean isUsedInIndicators() {
            return false;
        }

        @Override
        public DimensionDefinition[] dimensions() {
            return new DimensionDefinition[0];
        }
    }
}

