/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine;

import io.intino.sumus.engine.Attribute;
import io.intino.sumus.model.AttributeDefinition;
import io.intino.sumus.model.DimensionDefinition;
import io.intino.sumus.model.LedgerDefinition;
import java.util.Objects;

public abstract class AbstractAttribute
implements Attribute {
    protected final AttributeDefinition definition;

    public AbstractAttribute(AttributeDefinition definition) {
        this.definition = definition;
    }

    @Override
    public AttributeDefinition definition() {
        return this.definition;
    }

    protected abstract LedgerDefinition ledgerDefinition();

    @Override
    public boolean isUsedInIndicators() {
        return this.ledgerDefinition().indicators.stream().anyMatch(i -> i.attribute().equals(this.definition));
    }

    @Override
    public DimensionDefinition[] dimensions() {
        return (DimensionDefinition[])this.ledgerDefinition().dimensions.stream().filter(d -> d.attribute().equals(this.definition)).toArray(DimensionDefinition[]::new);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this == o || this.areEquals((Attribute)o);
    }

    private boolean areEquals(Attribute attribute) {
        return Objects.equals(this.name(), attribute.name()) && this.type().equals((Object)attribute.type());
    }

    public int hashCode() {
        return Objects.hash(this.name(), this.type());
    }

    public String toString() {
        return this.name();
    }
}

