package io.intino.sumus.engine.helpers;

import java.util.HashMap;
import java.util.function.BiFunction;

public class IgnoreCaseMap<T> extends HashMap<String, T> {

	@Override
	public T put(String key, T value) {
		return super.put(ignoreCase(key), value);
	}

	@Override
	public T get(Object key) {
		return super.get(ignoreCase(key));
	}

	@Override
	public T merge(String key, T value, BiFunction<? super T, ? super T, ? extends T> remappingFunction) {
		return super.merge(ignoreCase(key), value, remappingFunction);
	}

	private String ignoreCase(Object key) {
		return key != null ? key.toString().toLowerCase() : null;
	}
}
