package io.intino.sumus.engine.filters;

import io.intino.sumus.engine.Filter;

import java.util.List;

import static java.util.Arrays.stream;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class CompositeFilter implements Filter {
	private final List<Filter> filters;

	public static Filter of(Filter... filters) {
		if (filters.length == 0) return None;
		if (filters.length == 1) return filters[0];
		if (anyIsAll(filters)) return All;
		return new CompositeFilter(filters);
	}

	static boolean anyIsAll(Filter... filters) {
		return stream(filters).anyMatch(f -> f == All);
	}

	private CompositeFilter(Filter... filters) {
		this.filters = stream(filters).filter(f->f != Filter.None).collect(toList());
	}

	@Override
	public boolean accepts(int idx) {
		for (Filter f : filters)
			if (!f.accepts(idx)) return false;
		return true;
	}

	@Override
	public String toString() {
		return filters.stream().map(Object::toString).collect(joining(" | "));
	}
}
