package io.intino.sumus.engine;

import java.util.*;

import static java.util.stream.Collectors.groupingBy;

public interface Slice {
	default	Slice parent() { return null; }
	String name();
	Dimension dimension();
	default int level() { return 1; }

	boolean isNA();
	Index index();

	class SliceIndex implements Index {

		private final Index index;

		public SliceIndex(Set<Slice> slices) {
			this.index = groupedByDimension(slices);
		}

		@Override
		public boolean accepts(int idx) {
			return index.accepts(idx);
		}

		private Index groupedByDimension(Set<Slice> slices) {
			Collection<List<Slice>> slicesByDimension = slices.stream()
					.collect(groupingBy(Slice::dimension))
					.values();

			Index[] indices = new Index[slicesByDimension.size()];

			int i = 0;
			for(List<Slice> sliceList : slicesByDimension) {
				indices[i++] = sliceList.stream().map(Slice::index).filter(Objects::nonNull).reduce(Index::or).orElse(Index.None);
			}

			return Arrays.stream(indices).reduce(Index::and).orElse(Index.None);
		}
	}
}
