package io.intino.sumus.engine.ledgers;

import io.intino.sumus.engine.*;
import io.intino.sumus.model.LedgerDefinition;
import io.intino.sumus.model.LedgerDefinition.Content;
import io.intino.sumus.model.LedgerDefinition.Format;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static java.util.Collections.emptyList;

public class EmptyLedger implements Ledger {

	@Override
	public LedgerDefinition definition() {
		return new LedgerDefinition(Content.Events, Format.Tsv);
	}

	@Override
	public int size() {
		return 0;
	}

	@Override
	public List<Attribute> attributes() {
		return emptyList();
	}

	@Override
	public List<Dimension> dimensions() {
		return emptyList();
	}

	@Override
	public Iterable<Fact> facts(Filter filter) {
		return emptyList();
	}

	@Override
	public Query cube() {
		return new Query() {
			@Override
			public Query filter(Filter filter) {
				return this;
			}

			@Override
			public Query dimensions(List<Dimension> dimensions) {
				return this;
			}

			@Override
			public Cube build() {
				return new Cube() {
					@Override
					public List<? extends Dimension> dimensions() {
						return emptyList();
					}

					@Override
					public List<? extends Cell> cells() {
						return emptyList();
					}

					@Override
					public Map<String, ? extends Cell> cellMap() {
						return new HashMap<>();
					}

					@Override
					public Iterable<Fact> facts(Filter filter) {
						return emptyList();
					}
				};
			}
		};
	}

}
