package io.intino.sumus.engine.dimensions;

import io.intino.sumus.model.Classifier;
import io.intino.sumus.engine.Lookup;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.engine.SumusException;

import java.util.List;
import java.util.function.Predicate;

import static java.util.stream.Collectors.toList;

public class NumericalDimension extends AbstractDimension {

	private final String name;

	public NumericalDimension(Lookup lookup, String name, Classifier classifier) {
		super(lookup);
		this.name = name;
		this.slices.addAll(slicesOf(classifier));
		if (lookup.hasNA()) this.slices.add(new DimensionSlice());

	}

	@SuppressWarnings("unchecked")
	private List<Slice> slicesOf(Classifier classifier) {
		return classifier.categories().stream()
				.map(c -> new DimensionSlice(c, (Predicate<Object>) classifier.predicateOf(c)))
				.collect(toList());
	}

	@Override
	public String name() {
		return name;
	}

	@Override
	protected void check() {
		if (lookup.type().isNumeric()) return;
		throw new SumusException("Numerical dimension must use a numeric column");
	}
}
