/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.builders.accumulators;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.builders.accumulators.BuilderAccumulator;
import java.util.List;

public class IntegerAccumulator
extends BuilderAccumulator {
    private int count = 0;
    private long sum = 0L;
    private long min = Long.MAX_VALUE;
    private long max = Long.MIN_VALUE;

    public IntegerAccumulator(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Object value) {
        if (value == null) {
            return;
        }
        IntegerAccumulator integerAccumulator = this;
        synchronized (integerAccumulator) {
            ++this.count;
            this.sum += ((Long)value).longValue();
            this.min = Math.min(this.min, (Long)value);
            this.max = Math.max(this.max, (Long)value);
        }
    }

    @Override
    public List<Cube.Indicator> indicators() {
        return List.of(Cube.indicator("count(" + this.name + ")", this.count), Cube.indicator("ratio(" + this.name + ")", (double)this.count / (double)this.total), Cube.indicator("sum(" + this.name + ")", this.sum), Cube.indicator("average(" + this.name + ")", this.count > 0 ? (double)this.sum / (double)this.count : 0.0), Cube.indicator("min(" + this.name + ")", this.min), Cube.indicator("max(" + this.name + ")", this.max));
    }
}

