/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.builders;

import io.intino.sumus.engine.Attribute;
import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Fact;
import io.intino.sumus.engine.Filter;
import io.intino.sumus.engine.Ledger;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.engine.builders.CellBuilder;
import io.intino.sumus.engine.builders.accumulators.BuilderAccumulator;
import io.intino.sumus.engine.builders.accumulators.CountAccumulator;
import io.intino.sumus.engine.builders.accumulators.DateAccumulator;
import io.intino.sumus.engine.builders.accumulators.IntegerAccumulator;
import io.intino.sumus.engine.builders.accumulators.NumberAccumulator;
import io.intino.sumus.engine.builders.accumulators.TimeAccumulator;
import io.intino.sumus.engine.filters.CompositeFilter;
import io.intino.sumus.engine.filters.SliceFilter;
import io.intino.sumus.engine.helpers.IgnoreCaseMap;
import io.intino.sumus.model.LedgerDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class CubeBuilder {
    private final Ledger ledger;
    private final LedgerDefinition definition;
    private final Filter filter;
    private final List<Dimension> dimensions;

    public CubeBuilder(Ledger ledger, Filter filter, Dimension ... dimensions) {
        this(ledger, filter, Arrays.asList(dimensions));
    }

    public CubeBuilder(Ledger ledger, Filter filter, List<Dimension> dimensions) {
        this.ledger = ledger;
        this.definition = ledger.definition();
        this.filter = filter;
        this.dimensions = dimensions;
    }

    public List<CellBuilder> builders() {
        ArrayList<CellBuilder> result = new ArrayList<CellBuilder>();
        int size = this.dimensions.size();
        for (int i = 0; i < size; ++i) {
            result.addAll(this.builders(List.of(), this.dimensions.subList(i, size)));
        }
        result.add(new CellBuilder(this.definition.indicators));
        return result;
    }

    private List<CellBuilder> builders(List<Slice> slices, List<Dimension> dimensions) {
        List<CellBuilder> result = this.export(slices);
        if (dimensions.isEmpty()) {
            return result;
        }
        List<Slice> head = this.filter.crop(dimensions.get(0).slices());
        List<Dimension> tail = dimensions.subList(1, dimensions.size());
        for (Slice slice : head) {
            List<CellBuilder> cells = this.builders(this.join(slices, slice), tail);
            result.addAll(cells);
        }
        return result;
    }

    private List<CellBuilder> export(List<Slice> slices) {
        List result = slices.isEmpty() ? List.of() : List.of(new CellBuilder(this.definition.indicators, slices));
        return new ArrayList<CellBuilder>(result);
    }

    private List<Slice> join(List<Slice> slices, Slice slice) {
        ArrayList<Slice> result = new ArrayList<Slice>(slices);
        result.add(slice);
        return result;
    }

    public Cube build() {
        return this.cubeOf(this.executeQuery());
    }

    private List<CellBuilder> executeQuery() {
        return this.filter == Filter.All ? Collections.emptyList() : this.fill(this.withAccumulators(this.builders()));
    }

    private List<CellBuilder> withAccumulators(List<CellBuilder> builders) {
        for (CellBuilder builder : builders) {
            this.createAccumulators(builder);
        }
        return builders;
    }

    private List<CellBuilder> fill(List<CellBuilder> builders) {
        for (Fact fact : this.ledger.facts(this.filter)) {
            if (!this.filter.accepts(fact.idx())) continue;
            this.fill(builders, fact);
        }
        return builders;
    }

    private void fill(List<CellBuilder> builders, Fact fact) {
        for (CellBuilder builder : builders) {
            builder.add(fact);
        }
    }

    private void terminate(ExecutorService executor) {
        try {
            executor.shutdown();
            executor.awaitTermination(40L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void createAccumulators(CellBuilder builder) {
        List<Attribute> attributes = this.ledger.attributes();
        attributes.stream().filter(Attribute::isUsedInIndicators).forEach(a -> builder.add(this.accumulatorOf((Attribute)a)));
    }

    private BuilderAccumulator accumulatorOf(Attribute attribute) {
        if (attribute.type().isInteger()) {
            return new IntegerAccumulator(attribute.name());
        }
        if (attribute.type().isReal()) {
            return new NumberAccumulator(attribute.name());
        }
        if (attribute.type().isDate()) {
            return new DateAccumulator(attribute.name());
        }
        if (attribute.type().isTime()) {
            return new TimeAccumulator(attribute.name());
        }
        return new CountAccumulator(attribute.name());
    }

    private Cube cubeOf(final List<CellBuilder> builders) {
        return new Cube(){
            private final Map<String, Cube.Cell> cells = this.buildCells();

            @Override
            public List<Dimension> dimensions() {
                return CubeBuilder.this.dimensions;
            }

            @Override
            public List<Cube.Cell> cells() {
                return new ArrayList<Cube.Cell>(this.cells.values());
            }

            @Override
            public Map<String, Cube.Cell> cellMap() {
                return this.cells;
            }

            @Override
            public Iterable<Fact> facts(Filter filter) {
                Filter local = CompositeFilter.of(CubeBuilder.this.filter, filter);
                return local == Filter.All ? Collections.emptyList() : CubeBuilder.this.ledger.facts(local);
            }

            private Map<String, Cube.Cell> buildCells() {
                return builders.stream().map(b -> b.cell(this.facts(CompositeFilter.of(CubeBuilder.this.filter, SliceFilter.of(b.slices))))).collect(Collectors.toMap(Object::toString, c -> c, (a, b) -> b, IgnoreCaseMap::new));
            }
        };
    }
}

