/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine;

import io.intino.sumus.engine.Attribute;
import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Fact;
import io.intino.sumus.engine.Filter;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.engine.filters.SliceFilter;
import io.intino.sumus.engine.helpers.Finder;
import io.intino.sumus.model.LedgerDefinition;
import java.util.Arrays;
import java.util.List;

public interface Ledger {
    public LedgerDefinition definition();

    public int size();

    public List<Attribute> attributes();

    default public Attribute attribute(String name) {
        return new Finder<Attribute>(this.attributes()).find(name);
    }

    public List<Dimension> dimensions();

    default public Dimension dimension(String name) {
        return new Finder<Dimension>(this.dimensions()).find(name);
    }

    default public Slice slice(String slice) {
        String[] split = slice.split(":");
        return this.slice(split[0], split[1]);
    }

    default public Slice slice(String dimension, String slice) {
        return this.dimension(dimension).slice(slice);
    }

    default public Iterable<Fact> facts() {
        return this.facts(Filter.None);
    }

    public Iterable<Fact> facts(Filter var1);

    public Query cube();

    public static interface Query {
        public Query filter(Filter var1);

        default public Query filter(Slice ... slices) {
            return this.filter(SliceFilter.of(slices));
        }

        public Query dimensions(List<Dimension> var1);

        default public Query dimensions(Dimension ... dimensions) {
            return this.dimensions(Arrays.asList(dimensions));
        }

        public Cube build();
    }
}

