package io.intino.sumus.engine.dimensions;

import java.util.Objects;

public class Category {
	public final int id;
	public final String label;
	public final Category parent;

	public Category(int id, String label, Category parent) {
		this.id = id;
		this.label = label;
		this.parent = parent;
	}

	@Override
	public boolean equals(Object o) {
		if (o == null || getClass() != o.getClass()) return false;
		return this == o || id == ((Category) o).id;
	}

	@Override
	public int hashCode() {
		return Objects.hash(id);
	}

	@Override
	public String toString() {
		return id + ":" + label;
	}
}
