package io.intino.sumus.engine.builders.accumulators;

import io.intino.sumus.engine.Cube;

import java.time.LocalDate;
import java.util.List;

import static io.intino.sumus.engine.Cube.indicator;

public class DateAccumulator extends BuilderAccumulator {
	private int count;
	private long min;
	private long max;

	public DateAccumulator(String name) {
		super(name);
		this.count = 0;
		this.min = Long.MAX_VALUE;
		this.max = Long.MIN_VALUE;
	}

	@Override
	public void add(Object value) {
		if (value == null) return;
		synchronized (this) {
			this.count++;
			this.min = Math.min(this.min, (long) value);
			this.max = Math.max(this.max, (long) value);
		}
	}

	@Override
	public List<Cube.Indicator> indicators() {
		return List.of(
				indicator("count(" + name + ")", count),
				indicator("min(" + name + ")", minDate()),
				indicator("max(" + name + ")", maxDate())
		);
	}

	private LocalDate minDate() {
		return min == Long.MAX_VALUE ? LocalDate.MAX : LocalDate.ofEpochDay(min);
	}

	private LocalDate maxDate() {
		return max == Long.MIN_VALUE ? LocalDate.MIN : LocalDate.ofEpochDay(max);
	}
}
