/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine;

import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Index;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public interface Slice {
    default public Slice parent() {
        return null;
    }

    public String name();

    public Dimension dimension();

    default public int level() {
        return 1;
    }

    public boolean isNA();

    public Index index();

    public static class SliceIndex
    implements Index {
        private final Collection<List<Slice>> slices;

        public SliceIndex(Set<Slice> slices) {
            this.slices = this.groupedByDimension(slices);
        }

        @Override
        public boolean accepts(int idx) {
            for (List<Slice> s : this.slices) {
                if (this.accepts(s, idx)) continue;
                return false;
            }
            return true;
        }

        private boolean accepts(List<Slice> slices, int idx) {
            for (Slice s : slices) {
                if (!s.index().accepts(idx)) continue;
                return true;
            }
            return false;
        }

        private Collection<List<Slice>> groupedByDimension(Set<Slice> slices) {
            return slices.stream().collect(Collectors.groupingBy(Slice::dimension)).values();
        }
    }
}

