package io.intino.sumus.engine.builders.accumulators;

import io.intino.sumus.engine.Cube;

import java.util.List;

import static io.intino.sumus.engine.Cube.indicator;

public class NumberAccumulator extends BuilderAccumulator {
	private int count;
	private double sum;
	private double min;
	private double max;

	public NumberAccumulator(String name) {
		super(name);
		this.count = 0;
		this.sum = 0;
		this.min = Double.MAX_VALUE;
		this.max = Double.MIN_VALUE;
	}

	public void add(Object value) {
		if (value == null) return;
		synchronized (this) {
			this.count++;
			this.sum = this.sum + (double) value;
			this.min = Math.min(this.min, (double) value);
			this.max = Math.max(this.max, (double) value);
		}
	}

	@Override
	public List<Cube.Indicator> indicators() {
		return List.of(
				indicator("count(" + name + ")", count),
				indicator("ratio(" + name + ")", (double) count/total),
				indicator("sum(" + name + ")", sum),
				indicator("average(" + name + ")", count > 0 ? sum / count : 0),
				indicator("min(" + name + ")", min),
				indicator("max(" + name + ")", max)
		);
	}
}
