package io.intino.sumus.engine.builders.accumulators;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.dimensions.Category;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static io.intino.sumus.engine.Cube.indicator;

public class CountAccumulator extends BuilderAccumulator {

	private final Map<String, Integer> counts = new HashMap<>();

	public CountAccumulator(String name) {
		super(name);
	}

	@Override
	public void add(Object value) {
		synchronized (this) {
			increment("");
			if (value instanceof Category) increment(((Category)value).label);
		}
	}

	private void increment(String key) {
		this.counts.put(key, this.counts.getOrDefault(key, 0) + 1);
	}

	@Override
	public List<Cube.Indicator> indicators() {
		return counts.entrySet().stream()
				.map(e->indicatorsOf(segmentOf(e.getKey()),e.getValue()))
				.flatMap(Collection::stream)
				.collect(Collectors.toList());
	}

	private String segmentOf(String key) {
		return key.isEmpty() ? "" : " with " + key;
	}

	private List<Cube.Indicator> indicatorsOf(String segment, int count) { // TODO: check segment in name
		return List.of(
				indicator("count(" + this.name + ")" + segment, count),
				indicator("ratio(" + this.name + ")" + segment, (double) count / total)
		);
	}

}
