package io.intino.sumus.engine;

import java.util.Collection;
import java.util.List;
import java.util.Set;

import static java.util.stream.Collectors.groupingBy;

public interface Slice {
	default	Slice parent() { return null; }
	String name();
	Dimension dimension();
	default int level() { return 1; }

	boolean isNA();
	Index index();

	class SliceIndex implements Index {
		private final Collection<List<Slice>> slices;

		public SliceIndex(Set<Slice> slices) {
			this.slices = groupedByDimension(slices);
		}

		@Override
		public boolean accepts(int idx) {
			for (List<Slice> s : slices)
				if (!accepts(s, idx)) return false;
			return true;
		}

		private boolean accepts(List<Slice> slices, int idx) {
			for (Slice s : slices)
				if (s.index().accepts(idx)) return true;
			return false;
		}

		private Collection<List<Slice>> groupedByDimension(Set<Slice> slices) {
			return slices.stream()
					.collect(groupingBy(Slice::dimension))
					.values();
		}

	}
}
