package io.intino.sumus.chronos.timelines.readers;

import io.intino.sumus.chronos.timelines.TimelineReader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;

import static java.nio.file.StandardOpenOption.READ;

public class FileTimelineReader extends TimelineReader {

	public FileTimelineReader(File file) throws IOException {
		this(Channels.newChannel(new BufferedInputStream(new FileInputStream(file), 32 * 1024)));
	}

	public FileTimelineReader(ReadableByteChannel channel) throws IOException {
		super(channel);
	}

	public static class Seekable extends FileTimelineReader {

		public Seekable(File file) throws IOException {
			super(FileChannel.open(file.toPath(), READ));
		}
	}
}
