package io.intino.sumus.chronos;

import io.intino.sumus.chronos.timelines.blocks.SensorModel;

import java.util.Collection;
import java.util.Map;

public class MeasurementsVector {

	public static MeasurementsVector of(Map<String, Number> measurements) {
		return new MeasurementsVector(measurements.keySet()).set(measurements);
	}

	private final TimelineStore.SensorModel sensorModel;
	private final double[] values;

	public MeasurementsVector(Collection<String> magnitudes) {
		this(new SensorModel(magnitudes.toArray(String[]::new)));
	}

	public MeasurementsVector(String... magnitudes) {
		this(new SensorModel(magnitudes));
	}

	public MeasurementsVector(Magnitude... magnitudes) {
		this(new SensorModel(magnitudes));
	}

	public MeasurementsVector(TimelineStore.SensorModel sensorModel) {
		this.sensorModel = sensorModel;
		this.values = new double[sensorModel.size()];
	}

	public MeasurementsVector set(Map<String, Number> measurements) {
		measurements.forEach((magnitude, value) -> set(magnitude, value.doubleValue()));
		return this;
	}

	public MeasurementsVector set(String magnitude, MeasurementBuffer buffer) {
		return set(magnitude, buffer.reduce());
	}

	public MeasurementsVector set(String magnitude, double value) {
		this.values[sensorModel.indexOf(magnitude)] = value;
		return this;
	}

	public TimelineStore.SensorModel sensorModel() {
		return sensorModel;
	}

	public double[] toArray() {
		return values;
	}
}
