package io.intino.sumus.chronos.timelines.stores;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;

import static java.nio.file.StandardOpenOption.READ;

public class FileTimelineStore extends AbstractTimelineStore {

	private final File file;

	public FileTimelineStore(File file) throws IOException {
		this.file = file;
		init();
	}

	public FileTimelineStore(String file) throws IOException {
		this(new File(file));
		init();
	}

	@Override
	protected SeekableByteChannel openChannel() throws IOException {
		return FileChannel.open(file.toPath(), READ);
	}

	public File file() {
		return file;
	}
}
