package io.intino.sumus.chronos;

import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public interface Timeline extends Iterable<Timeline.Point> {
	Timeline Null = new TimelineImpl(new Instant[0], new HashMap<>(0));

	static Timeline empty() {
		return new TimelineImpl(new Instant[0], new HashMap<>());
	}

	static Timeline.Builder builder(int size) {
		return new TimelineImpl.Builder(size);
	}

	static Timeline.Builder builder(Instant[] instants) {
		return new TimelineImpl.Builder(instants);
	}


	int magnitudesCount();

	int instantsCount();

	default int size() {return instantsCount();}

	default boolean isEmpty() {return size() == 0;}

	Set<Magnitude> magnitudes();

	Instant[] instants();

	Map<Magnitude, double[]> measurements();

	Instant instant(int index);

	boolean has(String magnitude);

	boolean has(Magnitude magnitude);

	TimeSeries get(String magnitude);

	TimeSeries get(Magnitude magnitude);

	boolean isBefore(Timeline timeline);

	boolean isAfter(Timeline timeline);

	Point first();

	Point last();

	Point at(Instant instant);

	Timeline head(int length);

	Timeline tail(int length);

	Timeline from(Instant instant);

	Timeline from(Instant instant, int length);

	Timeline from(Instant instant, Instant to);

	Timeline to(Instant instant);

	Stream<Timeline.Point> stream();

	@Override
	Iterator<Timeline.Point> iterator();

	Timeline add(Timeline timeline);

	Timeline add(String magnitude, TimeSeries timeSeries);

	Timeline add(Magnitude magnitude, TimeSeries timeSeries);

	Timeline add(String magnitude, Function<Timeline, TimeSeries> function);

	Timeline add(Magnitude magnitude, Function<Timeline, TimeSeries> function);

	Timeline concat(Timeline timeline);

	Timeline compose(Function<Magnitude, Magnitude> function);

	Timeline resampleBy(Period period);

	Timeline resampleBy(Period period, int size);

	Timeline execute(Program program);

	Timeline interpolate();


	interface Point {
		Instant instant();
		Set<Magnitude> magnitudes();
		boolean has(String magnitude);
		boolean has(Magnitude magnitude);
		double value(String magnitude);
		double value(Magnitude magnitude);
		Stream<Point> forward();
		Stream<Point> backward();
		Point next();
		Point prev();
		Point step(int value);
	}

	interface Builder {
		Timeline build();
		Magnitude get(String magnitude);
		Builder put(Timeline timeline);
		Builder put(Magnitude magnitude, TimeSeries series);
		Builder put(Magnitude magnitude, double[] values);
		Builder put(Map<Magnitude, double[]> values);
		Builder set(Instant instant);
		boolean isComplete();
		void set(TimelineStore.SensorModel sensorModel, TimelineStore.Data dataBlock);
		void set(Magnitude[] magnitudes, Instant instant, double[] values);
		Builder set(String magnitude, double value);
		Builder set(Magnitude magnitude, double value);
		void register(Magnitude magnitude);
		TimeSeries series(Magnitude magnitude);
	}
}
