package io.intino.sumus.chronos.itl;

import io.intino.sumus.chronos.Timeline;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

public class ItlReader {
	public static Timeline read(File file) throws IOException {
		return read(linesIn(file));
	}

	public static Timeline read(List<String> lines) {
		ItlParser parser = new ItlParser(numberOfMeasurementsIn(lines));
		lines.forEach(parser);
		return parser.timeline();
	}

	private static List<String> linesIn(File file) throws IOException {
		try (BufferedReader reader = new BufferedReader(new FileReader(file))) {
			return reader.lines().filter(l -> !l.isEmpty()).collect(Collectors.toList());
		}
	}

	private static int numberOfMeasurementsIn(List<String> lines) {
		return (int) lines.stream().filter(l -> l.charAt(0) != '@').count();
	}

}
