/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos.itl;

import io.intino.sumus.chronos.Period;
import io.intino.sumus.chronos.Timeline;
import java.time.Instant;
import java.util.function.Consumer;

public class ItlParser
implements Consumer<String> {
    private final Timeline.Builder builder;
    private String[] measurements;
    private Period period;
    private Instant instant;

    public ItlParser(int size) {
        this.builder = new Timeline.Builder(size);
    }

    @Override
    public void accept(String line) {
        if (line.startsWith("@")) {
            this.loadAnnotation(line);
        } else {
            this.loadMeasurement(line.split("\t"));
        }
    }

    private void loadAnnotation(String line) {
        int index = line.indexOf(32);
        if (index < 0) {
            return;
        }
        String metadata = line.substring(1, index).toLowerCase();
        String data = line.substring(index + 1);
        switch (metadata) {
            case "instant": {
                this.instant = Instant.parse(data);
                break;
            }
            case "period": {
                this.period = Period.each(data);
                break;
            }
            case "measurements": {
                this.measurements = data.split(",");
            }
        }
    }

    private void loadMeasurement(String[] line) {
        this.checkModel();
        this.builder.set(this.instant);
        int size = Math.min(line.length, this.measurements.length);
        for (int i = 0; i < size; ++i) {
            this.builder.set(this.measurements[i], this.parse(line[i]));
        }
        this.instant = this.period.next(this.instant);
    }

    private double parse(String s) {
        return s.isEmpty() ? Double.NaN : Double.parseDouble(s);
    }

    private void checkModel() {
        if (this.period == null) {
            throw new IllegalArgumentException("No period defined");
        }
        if (this.instant == null) {
            throw new IllegalArgumentException("No instant defined");
        }
        if (this.measurements == null) {
            throw new IllegalArgumentException("No measurements defined");
        }
    }

    public Timeline timeline() {
        return this.builder.close();
    }
}

