package io.intino.sumus.chronos.models.descriptive.timeseries;

import io.intino.sumus.chronos.TimeSeries;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;

import java.util.Arrays;

import static org.apache.commons.math3.transform.TransformType.FORWARD;

public class Spectrum {
	public final double[] values;

	private Spectrum(double[] values) {
		this.values = values;
	}

	public static Spectrum of(TimeSeries timeSeries) {
		return new Spectrum(calculate(timeSeries.values));
	}

	private static double[] calculate(double[] values) {
		FastFourierTransformer fft = new FastFourierTransformer(DftNormalization.STANDARD);
		Complex[] frequencies = fft.transform(values, FORWARD);
		return Arrays.stream(frequencies).mapToDouble(Complex::abs).toArray();
	}

}
