/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.time.models.descriptive.timeseries;

import io.intino.sumus.time.TimeSeries;
import java.util.Arrays;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;
import org.apache.commons.math3.transform.TransformType;

public class Spectrum {
    public final double[] values;

    private Spectrum(double[] values) {
        this.values = values;
    }

    public static Spectrum of(TimeSeries timeSeries) {
        return new Spectrum(Spectrum.calculate(timeSeries.values));
    }

    private static double[] calculate(double[] values) {
        FastFourierTransformer fft = new FastFourierTransformer(DftNormalization.STANDARD);
        Complex[] frequencies = fft.transform(values, TransformType.FORWARD);
        return Arrays.stream(frequencies).mapToDouble(Complex::abs).toArray();
    }
}

