/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.time.models.descriptive.timeseries;

import com.tdunning.math.stats.TDigest;
import io.intino.sumus.time.Magnitude;
import io.intino.sumus.time.TimeSeries;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.PoissonDistribution;

public class Distribution {
    final Magnitude.Model model;
    private final TDigest tdigest;
    public double max = -2.147483648E9;
    public double min = 2.147483647E9;
    public double open;
    public double close;
    public double sum;
    public int count;
    private double mean;
    private double m2;

    public static Distribution of(TimeSeries timeSeries) {
        return new Distribution(timeSeries.model).add(timeSeries.values);
    }

    public Distribution(TimeSeries timeSeries) {
        this(timeSeries.model);
        for (TimeSeries.Point point : timeSeries) {
            this.add(point.value());
        }
    }

    public Distribution(Magnitude.Model model) {
        this.model = model;
        this.tdigest = model.distributionModel == Magnitude.Model.DistributionModel.Unknown ? TDigest.createAvlTreeDigest((double)200.0) : null;
    }

    Distribution add(double[] values) {
        for (double value : values) {
            this.add(value);
        }
        return this;
    }

    public void add(double value) {
        if (Double.isNaN(value)) {
            return;
        }
        this.open = this.count == 0 ? value : this.open;
        this.close = value;
        this.min = Math.min(this.min, value);
        this.max = Math.max(this.max, value);
        this.sum += value;
        ++this.count;
        double delta = value - this.mean;
        this.mean += delta / (double)this.count;
        this.m2 += delta * (value - this.mean);
        if (this.tdigest != null) {
            this.tdigest.add(value);
        }
    }

    public double mean() {
        return this.mean;
    }

    public double sd() {
        return this.count >= 2 ? Math.sqrt(this.m2 / (double)(this.count - 1)) : Double.NaN;
    }

    public double probabilityOf(double value) {
        if (this.model.distributionModel == Magnitude.Model.DistributionModel.Poisson) {
            return this.tail(this.poissonCumulativeProbabilityOf((int)value));
        }
        if (this.model.distributionModel == Magnitude.Model.DistributionModel.Unknown) {
            return this.tail(this.tdigest.cdf(value));
        }
        return this.tail(this.normalCumulativeProbabilityOf(value));
    }

    public int percentile(double value) {
        return (int)(this.probabilityOf(value) * 100.0);
    }

    public int quartile(double value) {
        return (int)(this.probabilityOf(value) * 4.0);
    }

    private double tail(double p) {
        if (this.model.distributionTail == Magnitude.Model.DistributionTail.Down) {
            return p;
        }
        if (this.model.distributionTail == Magnitude.Model.DistributionTail.Up) {
            return 1.0 - p;
        }
        return Math.min(p, 1.0 - p) * 2.0;
    }

    private double poissonCumulativeProbabilityOf(int quantile) {
        return new PoissonDistribution(this.mean).cumulativeProbability(quantile);
    }

    private double normalCumulativeProbabilityOf(double quantile) {
        return new NormalDistribution(this.mean, this.sd()).cumulativeProbability(quantile);
    }

    public String toString() {
        return String.format("min=%s\nmax=%s\nopen=%s\nclose=%s\nsum=%s\ncount=%d\nmean=%s\nsd=%s\n", this.min, this.max, this.open, this.close, this.sum, this.count, this.mean, this.sd());
    }
}

