/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.time.models.descriptive.timeline;

import io.intino.sumus.time.Magnitude;
import io.intino.sumus.time.Timeline;
import io.intino.sumus.time.models.descriptive.sequence.Sequence;
import io.intino.sumus.time.models.descriptive.timeseries.Distribution;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class Summary
implements Iterable<Point> {
    private final String[] symbols;
    private final Map<String, Integer> index;
    private final Map<Magnitude, Distribution[]> distributions;

    public static Builder of(Timeline timeline) {
        return new Builder(timeline);
    }

    private Summary(String[] symbols, Map<Magnitude, Distribution[]> distributions) {
        this.symbols = symbols;
        this.index = this.index(symbols);
        this.distributions = distributions;
    }

    private Map<String, Integer> index(String[] symbols) {
        HashMap<String, Integer> index = new HashMap<String, Integer>();
        for (String symbol : symbols) {
            index.put(symbol, index.size());
        }
        return index;
    }

    public int length() {
        return this.symbols.length;
    }

    public String[] labels() {
        return this.symbols;
    }

    public int indexOf(String label) {
        return this.index.get(label);
    }

    public Set<Magnitude> measurements() {
        return this.distributions.keySet();
    }

    public Point first() {
        return this.point(0);
    }

    public Point last() {
        return this.point(this.length() - 1);
    }

    public Point point(String label) {
        return this.point(this.indexOf(label));
    }

    public Point point(int index) {
        return new Point(index);
    }

    public Point[] head(int length) {
        Point[] points = new Point[length];
        Arrays.setAll(points, this::point);
        return points;
    }

    public Point[] tail(int length) {
        Point[] points = new Point[length];
        Arrays.setAll(points, i -> this.point(this.length() - i - 1));
        return points;
    }

    public Stream<Point> stream() {
        return IntStream.range(0, this.length()).mapToObj(this::point);
    }

    @Override
    public Iterator<Point> iterator() {
        return new Iterator<Point>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < Summary.this.symbols.length;
            }

            @Override
            public Point next() {
                return Summary.this.point(this.i++);
            }
        };
    }

    public static String byYear(Timeline.Point point) {
        return Summary.timetag(point.instant(), 4);
    }

    public static String byMonth(Timeline.Point point) {
        return Summary.timetag(point.instant(), 6);
    }

    public static String byWeek(Timeline.Point point) {
        LocalDate date = point.instant().atZone(ZoneOffset.UTC).toLocalDate();
        int year = date.get(ChronoField.YEAR);
        int week = date.get(ChronoField.ALIGNED_WEEK_OF_YEAR);
        return String.format("%dW%02d", year, week);
    }

    public static String days(Timeline.Point point) {
        return Summary.timetag(point.instant(), 8);
    }

    public static String hours(Timeline.Point point) {
        return Summary.timetag(point.instant(), 10);
    }

    public static String minutes(Timeline.Point point) {
        return Summary.timetag(point.instant(), 12);
    }

    public static String seconds(Timeline.Point point) {
        return Summary.timetag(point.instant(), 14);
    }

    public static String daysOfWeek(Timeline.Point point) {
        int index = point.instant().atZone(ZoneOffset.UTC).toLocalDate().get(ChronoField.DAY_OF_WEEK);
        return DayOfWeek.of(index).toString();
    }

    public static String monthsOfYear(Timeline.Point point) {
        int index = point.instant().atZone(ZoneOffset.UTC).toLocalDate().get(ChronoField.MONTH_OF_YEAR);
        return Month.of(index).toString();
    }

    public static String byHourOfDay(Timeline.Point point) {
        int index = point.instant().atZone(ZoneOffset.UTC).toLocalDate().get(ChronoField.HOUR_OF_DAY);
        return String.format("%02d", index);
    }

    private static String timetag(Instant instant, int size) {
        char[] result = new char[size];
        char[] chars = instant.toString().toCharArray();
        int i = 0;
        int j = 0;
        while (j < size) {
            char c = chars[i];
            if (c >= '0' && c <= '9') {
                result[j++] = c;
            }
            ++i;
        }
        return new String(result);
    }

    public static class Builder {
        private final Timeline timeline;

        private Builder(Timeline timeline) {
            this.timeline = timeline;
        }

        public Summary by(Sequence.Quantization quantization) {
            Sequence sequence = new Sequence.Builder(this.timeline).by(quantization);
            Summary summary = new Summary(sequence.symbols(), this.distributions(sequence.symbols().length));
            for (Timeline.Point point : this.timeline) {
                summary.point(quantization.get(point)).add(point);
            }
            return summary;
        }

        private Map<Magnitude, Distribution[]> distributions(int size) {
            return this.timeline.magnitudes().stream().collect(Collectors.toMap(m -> m, m -> this.distributions((Magnitude)m, size)));
        }

        private Distribution[] distributions(Magnitude magnitude, int length) {
            Distribution[] result = new Distribution[length];
            Arrays.setAll(result, i -> new Distribution(magnitude.model));
            return result;
        }
    }

    public class Point {
        public final int index;

        private Point(int index) {
            assert (index >= 0) : index < this$0.length();
            this.index = index;
        }

        public String label() {
            return Summary.this.symbols[this.index];
        }

        public Distribution distribution(String measurement) {
            return this.distribution(new Magnitude(measurement));
        }

        public Distribution distribution(Magnitude magnitude) {
            return Summary.this.distributions.get(magnitude)[this.index];
        }

        public Point next() {
            return Summary.this.point(this.index + 1);
        }

        public Point step(int offset) {
            return Summary.this.point(this.index + offset);
        }

        public Point prev() {
            return Summary.this.point(this.index - 1);
        }

        public Stream<Point> forward() {
            return IntStream.range(this.index, Summary.this.length()).mapToObj(Summary.this::point);
        }

        public Stream<Point> backward() {
            return IntStream.iterate(this.index, i -> i >= 0, i -> i - 1).mapToObj(Summary.this::point);
        }

        public String toString() {
            return this.label();
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Point && this.index == ((Point)o).index;
        }

        public int hashCode() {
            return Objects.hash(this.index);
        }

        private void add(Timeline.Point point) {
            for (Magnitude magnitude : point.magnitudes()) {
                this.distribution(magnitude).add(point.value(magnitude));
            }
        }
    }
}

