/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.time.filters;

import io.intino.sumus.time.Filter;

public class Normalizer {
    public static Filter of(double min, double max) {
        return new MinMax(min, max)::execute;
    }

    public static Filter standard() {
        return Normalizer::z;
    }

    private static double[] z(double[] values) {
        double m = Normalizer.mean(values);
        double sd = Normalizer.standardDeviation(values, m);
        int length = values.length;
        double[] normalizedValues = new double[length];
        for (int i = 0; i < length; ++i) {
            normalizedValues[i] = (values[i] - m) / sd;
        }
        return normalizedValues;
    }

    private static double mean(double[] values) {
        double sum = 0.0;
        int count = 0;
        for (double value : values) {
            if (Double.isNaN(value)) continue;
            ++count;
            sum += value;
        }
        return sum / (double)count;
    }

    private static double standardDeviation(double[] values, double m) {
        double sum = 0.0;
        int count = 0;
        for (double value : values) {
            if (Double.isNaN(value)) continue;
            ++count;
            sum += Normalizer.sqr(value - m);
        }
        return Math.sqrt(sum / (double)count);
    }

    private static double sqr(double v) {
        return v * v;
    }

    public static class MinMax {
        private final double min;
        private final double max;

        public MinMax(double min, double max) {
            this.min = min;
            this.max = max;
        }

        public double[] execute(double[] values) {
            double[] range = this.rangeOf(values);
            double[] result = new double[values.length];
            double factor = (this.max - this.min) / (range[1] - range[0]);
            for (int i = 0; i < values.length; ++i) {
                result[i] = Double.isNaN(values[i]) ? Double.NaN : (values[i] - range[0]) * factor + this.min;
            }
            return result;
        }

        private double[] rangeOf(double[] values) {
            double[] range = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
            for (double value : values) {
                if (Double.isNaN(value)) continue;
                if (value < range[0]) {
                    range[0] = value;
                }
                if (!(value > range[1])) continue;
                range[1] = value;
            }
            return range;
        }
    }
}

