/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.model;

import io.intino.alexandria.Timetag;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.Node;
import io.intino.sumus.reporting.helpers.DashboardHelper;
import io.intino.sumus.reporting.model.Order;
import io.intino.sumus.reporting.model.Visibility;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public class InsightDefinition
implements Dashboard.Insight {
    public String id;
    public String label;
    public String ledger;
    public Dashboard.Insight.Type type;
    public Visibility visibility;
    public String order;
    public String[] dimensions;
    public String[] filters;
    public String[] dateFilters;
    public String[] indicators;
    public String[] slices;
    public Integer level;
    public String[] formats;
    public Integer maxItems;
    public Map<String, String> labels;
    public Map<String, String> options;
    public String node;

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String label() {
        return this.label != null ? this.label : "";
    }

    @Override
    public Dashboard.Insight.Type type() {
        return this.type;
    }

    @Override
    public String ledger() {
        return this.ledger;
    }

    @Override
    public String[] dimensions() {
        return this.dimensions != null ? this.dimensions : new String[]{};
    }

    @Override
    public String[] filters(Timetag timetag) {
        if (this.filters == null) {
            return new String[0];
        }
        return (String[])Arrays.stream(this.filters).map(f -> DashboardHelper.getValue(timetag, f)).toArray(String[]::new);
    }

    @Override
    public String[] indicators() {
        return this.indicators != null ? this.indicators : new String[]{};
    }

    @Override
    public String[] slices() {
        return this.slices == null ? new String[]{} : this.slices;
    }

    @Override
    public Integer level() {
        return this.level;
    }

    @Override
    public Visibility visibility() {
        return this.visibility != null ? this.visibility : Visibility.All;
    }

    @Override
    public Order order() {
        if (this.order == null) {
            return new Order(Order.Type.Descending);
        }
        if (!this.order.contains(":")) {
            return new Order(Order.Type.valueOf(this.order));
        }
        String[] d = this.order.split(":", -1);
        return new Order(Order.Type.valueOf(d[0]), d[1]);
    }

    @Override
    public Integer maxItems() {
        return this.maxItems != null ? this.maxItems : Integer.MAX_VALUE;
    }

    @Override
    public Map<String, String> labels() {
        return this.labels != null ? this.labels : Collections.emptyMap();
    }

    @Override
    public Map<String, String> formats() {
        if (this.formats == null) {
            return Collections.emptyMap();
        }
        return Arrays.stream(this.formats).filter(f -> f.contains(":")).map(d -> d.trim().split(":")).collect(Collectors.toMap(d -> d[0], d -> d[1], (a, b) -> a));
    }

    @Override
    public Map<String, String> options() {
        return this.options != null ? this.options : Collections.emptyMap();
    }

    @Override
    public Node.Type node() {
        return Arrays.stream(Node.Type.values()).filter(v -> v.name().equalsIgnoreCase(this.node)).findFirst().orElse(null);
    }

    @Override
    public String[] dateFilters(Timetag timetag) {
        if (this.dateFilters == null) {
            return new String[0];
        }
        return (String[])Arrays.stream(this.dateFilters).map(f -> DashboardHelper.getValue(timetag, f)).toArray(String[]::new);
    }
}

