/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.model;

import com.google.gson.Gson;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.helpers.DashboardHelper;
import io.intino.sumus.reporting.model.ReportDefinition;
import java.io.File;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DashboardDefinition
implements Dashboard {
    public static final String ReportExtension = ".report";
    public static final String DashboardsDirectory = "dashboards";
    public static final String DefinitionsDirectory = "definitions";
    public static final String StoryboardsDirectory = "storyboards";
    public String name;
    public String datamart;
    public String navigation;
    public String nodesFile;
    public String template;
    public String[] nodes;
    public String[] reportDefinitions;
    public ReportDefinition[] reports;
    public boolean isRealtime;
    public String locale;

    @Override
    public String name() {
        return this.name != null ? this.name : "unknown";
    }

    @Override
    public boolean isRealtime() {
        return this.isRealtime;
    }

    @Override
    public String navigation() {
        return this.navigation;
    }

    @Override
    public File datamart() {
        return new File(this.datamart);
    }

    public File nodesFile() {
        return new File(this.nodesFile);
    }

    @Override
    public Set<String> nodes() {
        return this.nodesFile != null ? DashboardDefinition.linesOf(new File(this.nodesFile)) : this.nodeNames();
    }

    public Set<String> nodeNames() {
        return this.nodes != null ? Set.of(this.nodes) : Collections.emptySet();
    }

    @Override
    public List<Dashboard.Report> reports() {
        return this.reportDefinitions().stream().map(d -> d).collect(Collectors.toList());
    }

    public Locale locale() {
        return DashboardHelper.localeOf(this.locale);
    }

    public List<ReportDefinition> reportDefinitions() {
        LinkedList<ReportDefinition> definitions = new LinkedList<ReportDefinition>();
        definitions.addAll(this.embeddedReportDefinitions());
        definitions.addAll(this.fileReportDefinitions());
        return definitions;
    }

    private List<ReportDefinition> embeddedReportDefinitions() {
        return this.reports != null ? Arrays.stream(this.reports).filter(Objects::nonNull).collect(Collectors.toList()) : Collections.emptyList();
    }

    private List<ReportDefinition> fileReportDefinitions() {
        if (this.reportDefinitions == null || this.reportDefinitions.length < 1) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.reportDefinitions).map(name -> new File(this.definitionsDirectory(), name + ReportExtension)).map(r -> ReportDefinition.load(r, this.storyboardsDirectory(), this.locale())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private File dashboardsDirectory() {
        return new File(this.datamart().getParent(), DashboardsDirectory);
    }

    private File storyboardsDirectory() {
        return new File(this.datamart().getParent(), StoryboardsDirectory);
    }

    private File definitionsDirectory() {
        return new File(this.dashboardsDirectory(), this.name() + "/definitions");
    }

    @Override
    public String template() {
        return DashboardHelper.content(new File(this.template));
    }

    public static DashboardDefinition fromJson(String definition) {
        return (DashboardDefinition)new Gson().fromJson(definition, DashboardDefinition.class);
    }

    private static Set<String> linesOf(File file) {
        Set<String> set;
        block8: {
            Stream<String> lines = Files.lines(file.toPath());
            try {
                set = lines.filter(l -> !l.isEmpty()).collect(Collectors.toSet());
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    return Collections.emptySet();
                }
            }
            lines.close();
        }
        return set;
    }
}

