/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.loaders;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.sumus.engine.model.AttributeDefinition;
import io.intino.sumus.engine.model.LedgerDefinition;
import io.intino.sumus.reporting.helpers.ResourceHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.Month;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class LedgerAggregator {
    private final File root;
    private final String separator;

    public LedgerAggregator(File root) {
        this(root, "\t");
    }

    public LedgerAggregator(File root, String separator) {
        this.root = root;
        this.separator = separator;
    }

    public String[][] aggregate(String ledger, Timetag timetag) throws AggregationException, FileNotFoundException, ParseException {
        return this.aggregate(ledger, this.loadDefinition(ledger), timetag);
    }

    public String[][] aggregate(String ledger, LedgerDefinition definition, Timetag timetag) throws AggregationException {
        return LedgerAggregator.isAggregable(definition) ? new Aggregator(ledger, definition, timetag).aggregate() : null;
    }

    private LedgerDefinition loadDefinition(String ledger) throws ParseException, FileNotFoundException {
        File file = new File(this.root, ledger + ".ledger");
        if (!file.exists()) {
            throw new FileNotFoundException("Ledger definition " + ledger + " not found");
        }
        return LedgerDefinition.load((File)this.root, (File)file);
    }

    public static boolean isAggregable(LedgerDefinition definition) {
        LedgerDefinition.Aggregation aggregation = definition.aggregation;
        return aggregation != null && aggregation.period != null && aggregation.ledger != null && definition.content != LedgerDefinition.Content.Master;
    }

    private class Aggregator {
        private final String ledger;
        private final Timetag timetag;
        private final LedgerDefinition definition;
        private final LedgerDefinition.Aggregation aggregation;

        public Aggregator(String ledger, LedgerDefinition definition, Timetag timetag) {
            this.ledger = ledger;
            this.definition = definition;
            this.aggregation = definition.aggregation;
            this.timetag = timetag;
        }

        public String[][] aggregate() throws AggregationException {
            return LedgerAggregator.isAggregable(this.definition) ? this.aggregateEvents() : null;
        }

        private String[][] aggregateEvents() throws AggregationException {
            return this.aggregateEvents(this.keyFunction());
        }

        private String[][] aggregateEvents(Function<String, String> function) {
            return function != null ? this.aggregateFilter(this.from(), this.timetag, function) : this.aggregateAll(this.from(), this.timetag);
        }

        private String[][] aggregateFilter(Timetag from, Timetag to, Function<String, String> function) {
            LinkedHashMap records = new LinkedHashMap();
            this.stream(from, to).forEach(line -> {
                String key = (String)function.apply((String)line);
                if (key != null) {
                    records.put(key, line);
                }
            });
            return this.toArray(records.values().stream());
        }

        private String[][] aggregateAll(Timetag from, Timetag to) {
            return this.toArray(this.stream(from, to));
        }

        private Stream<String> stream(Timetag from, Timetag to) {
            return StreamSupport.stream(from.iterateTo(to).spliterator(), false).map(this::baseLedger).filter(File::exists).flatMap(f -> ResourceHelper.lines(f).stream()).filter(l -> l != null && !l.isEmpty());
        }

        private Function<String, String> keyFunction() throws AggregationException {
            String key = this.aggregation.recordKey;
            if (key == null) {
                return null;
            }
            int index = this.attributeIndex(key);
            if (index < 0) {
                throw new AggregationException("Aggregation key attribute " + key + " not found in ledger " + this.ledger);
            }
            return line -> line.split(LedgerAggregator.this.separator, -1)[index];
        }

        private String[][] toArray(Stream<String> lines) {
            return (String[][])lines.map(l -> l.split(LedgerAggregator.this.separator)).toArray((int x$0) -> new String[x$0][]);
        }

        private int attributeIndex(String aggregationKey) {
            List attributes = this.definition.attributes.stream().map(AttributeDefinition::name).collect(Collectors.toList());
            return attributes.indexOf(aggregationKey);
        }

        private File baseLedger(Timetag timetag) {
            File baseLedgerFolder = new File(LedgerAggregator.this.root, this.aggregation.ledger);
            return new File(baseLedgerFolder, String.valueOf(timetag) + ".tsv");
        }

        private Timetag from() {
            LocalDate date = this.timetag.datetime().toLocalDate();
            switch (this.aggregation.period) {
                case Week: {
                    return this.toTimetag(io.intino.sumus.reporting.model.Scale.Week.startDate(date));
                }
                case Month: {
                    return this.toTimetag(io.intino.sumus.reporting.model.Scale.Month.startDate(date));
                }
                case Quarter: {
                    return this.toTimetag(io.intino.sumus.reporting.model.Scale.Quarter.startDate(date));
                }
                case Year: {
                    return this.toTimetag(this.getYearFrom(date));
                }
            }
            return this.timetag;
        }

        private LocalDate getYearFrom(LocalDate date) {
            Month month = this.parseMonth(this.aggregation.from);
            if (month == null) {
                return io.intino.sumus.reporting.model.Scale.Year.startDate(date);
            }
            LocalDate newDate = date.withDayOfMonth(1).withMonth(month.getValue());
            return date.isBefore(newDate) ? newDate.withYear(date.getYear() - 1) : newDate;
        }

        private Timetag toTimetag(LocalDate date) {
            return Timetag.of((LocalDate)date, (Scale)Scale.Day);
        }

        private Month parseMonth(String value) {
            return Arrays.stream(Month.values()).filter(m -> m.name().equalsIgnoreCase(value)).findFirst().orElse(null);
        }
    }

    public static class AggregationException
    extends Exception {
        public AggregationException(String message) {
            super(message);
        }
    }
}

