/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.helpers;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.logger.Logger;
import io.intino.sumus.reporting.ReactiveFunctions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Locale;

public class DashboardHelper {
    public static String content(File file) {
        try {
            return Files.readString(file.toPath());
        }
        catch (IOException e) {
            return "";
        }
    }

    public static String getValue(Timetag timetag, String value) {
        if (value == null || !value.contains("@")) {
            return value;
        }
        String word = value.substring(value.indexOf("@"));
        return value.replace(word, ReactiveFunctions.apply(word, timetag));
    }

    public static Locale localeOf(String lang) {
        try {
            return lang != null ? Locale.forLanguageTag(lang) : null;
        }
        catch (Throwable e) {
            Logger.warn((String)("Unknown locale language tag " + lang));
            return null;
        }
    }
}

