/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.builders.templates;

import io.intino.itrules.Engine;
import io.intino.itrules.template.Template;
import io.intino.sumus.reporting.builders.schemas.ColumnChart;
import io.intino.sumus.reporting.builders.schemas.GaugeChart;
import io.intino.sumus.reporting.builders.schemas.HtmlEmbedChart;
import io.intino.sumus.reporting.builders.schemas.List;
import io.intino.sumus.reporting.builders.schemas.MicrositeAction;
import io.intino.sumus.reporting.builders.schemas.MicrositeLink;
import io.intino.sumus.reporting.builders.schemas.PieChart;
import io.intino.sumus.reporting.builders.schemas.Table;
import io.intino.sumus.reporting.builders.schemas.TableBar;
import io.intino.sumus.reporting.builders.schemas.TimeNavigator;
import io.intino.sumus.reporting.builders.schemas.views.ViewChart;
import io.intino.sumus.reporting.builders.schemas.views.ViewConfig;
import io.intino.sumus.reporting.builders.templates.ColumnTemplate;
import io.intino.sumus.reporting.builders.templates.GaugeTemplate;
import io.intino.sumus.reporting.builders.templates.HtmlTemplate;
import io.intino.sumus.reporting.builders.templates.ListTemplate;
import io.intino.sumus.reporting.builders.templates.MicrositeTemplate;
import io.intino.sumus.reporting.builders.templates.PieTemplate;
import io.intino.sumus.reporting.builders.templates.TableBarTemplate;
import io.intino.sumus.reporting.builders.templates.TableTemplate;
import io.intino.sumus.reporting.builders.templates.TimeNavigatorTemplate;
import io.intino.sumus.reporting.builders.templates.ViewTemplate;
import java.text.NumberFormat;
import java.util.Locale;

public class Renderer {
    static final String TranslationMark = "::";
    static final NumberFormat GermanNumberFormat = NumberFormat.getNumberInstance(Locale.GERMAN);

    public static String render(Object object) {
        if (object instanceof TimeNavigator) {
            return Renderer.render(new TimeNavigatorTemplate(), object);
        }
        if (object instanceof TableBar) {
            return Renderer.render(new TableBarTemplate(), object);
        }
        if (object instanceof Table) {
            return Renderer.render(new TableTemplate(), object);
        }
        if (object instanceof ColumnChart) {
            return Renderer.render(new ColumnTemplate(), object);
        }
        if (object instanceof PieChart) {
            return Renderer.render(new PieTemplate(), object);
        }
        if (object instanceof GaugeChart) {
            return Renderer.render(new GaugeTemplate(), object);
        }
        if (object instanceof HtmlEmbedChart) {
            return Renderer.render(new HtmlTemplate(), object);
        }
        if (object instanceof MicrositeAction || object instanceof MicrositeLink) {
            return Renderer.render(new MicrositeTemplate(), object);
        }
        if (object instanceof List) {
            return Renderer.render(new ListTemplate(), object);
        }
        if (object instanceof ViewChart || object instanceof ViewChart.Select || object instanceof ViewChart.Function || object instanceof ViewChart.ViewDate || object instanceof ViewConfig || object instanceof ViewConfig.ViewLabels || object instanceof ViewConfig.ViewPlotLine) {
            return Renderer.render(new ViewTemplate(), object);
        }
        return "";
    }

    public static String render(Template template, Object object) {
        return new Engine(template).add("Escaped", v -> "'" + String.valueOf(v) + "'").add("Translated", Renderer::Translate).add("GermanFormat", Renderer::GermanFormat).render(object);
    }

    private static Object Translate(Object object) {
        if (!(object instanceof String)) {
            return object;
        }
        String value = ((String)object).replace(":", "");
        return TranslationMark + value + TranslationMark;
    }

    private static Object GermanFormat(Object object) {
        if (object instanceof Double || object instanceof Integer || object instanceof Long) {
            return GermanNumberFormat.format(object);
        }
        return object;
    }
}

