/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.builders;

import io.intino.alexandria.logger.Logger;
import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.Node;
import io.intino.sumus.reporting.builders.MicrositeActionBuilder;
import io.intino.sumus.reporting.builders.UIBuilder;
import io.intino.sumus.reporting.builders.schemas.Table;
import io.intino.sumus.reporting.builders.templates.Renderer;
import io.intino.sumus.reporting.helpers.CubesHelper;
import io.intino.sumus.reporting.insights.TableInsight;
import io.intino.sumus.reporting.model.Formatter;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TableBuilder
implements UIBuilder {
    protected final TableInsight insight;
    private final Dashboard.Report report;
    private final MicrositeActionBuilder microsite;

    public TableBuilder(Dashboard.Report report, Dashboard.Insight insight, MicrositeActionBuilder microsite) {
        this.insight = new TableInsight(insight);
        this.report = report;
        this.microsite = microsite;
    }

    @Override
    public String build(Cube cube, Node node) {
        try {
            Table table = new Table(this.insight.id(), this.insight.label(), this.attributes()).globalRow(this.globalRow(cube)).rows(this.rows(cube, node));
            return Renderer.render(table);
        }
        catch (Table.TableChartException e) {
            Logger.error((Throwable)e);
            return "";
        }
    }

    protected List<Table.Attribute> attributes() {
        return Arrays.stream(this.insight.indicators()).map(i -> new Table.Attribute((String)i, (String)i)).collect(Collectors.toList());
    }

    protected Table.Row globalRow(Cube cube) {
        return this.insight.maxItems() == Integer.MAX_VALUE ? new Table.Row("").cells(this.tableCells(cube.cell(""))) : null;
    }

    protected List<Table.Row> rows(Cube cube, Node node) {
        return this.insight.dimensions().length > 1 ? this.rowsCubeCells(cube, node) : this.rowSlices(cube, node);
    }

    private List<Table.Row> rowsCubeCells(Cube cube, Node node) {
        return cube.cells().stream().filter(Objects::nonNull).filter(this::containAllDimensions).filter(this::slicesMatchLevel).map(c -> this.row(c.toString(), cube, node, (Slice[])c.slices().toArray(Slice[]::new))).filter(Objects::nonNull).sorted(Table.sortMethodOf(this.insight.order())).limit(this.insight.maxItems().intValue()).collect(Collectors.toCollection(LinkedList::new));
    }

    private List<Table.Row> rowSlices(Cube cube, Node node) {
        List<Slice> slices = this.isNavigable(node) && this.isNotCustomLevel() ? this.slices(cube, node) : this.slices(cube);
        return slices.stream().map(slice -> this.row(slice.name(), cube, node, (Slice)slice)).filter(Objects::nonNull).sorted(Table.sortMethodOf(this.insight.order())).limit(this.insight.maxItems().intValue()).collect(Collectors.toCollection(LinkedList::new));
    }

    private Table.Row row(String name, Cube cube, Node node, Slice ... slices) {
        List<Table.Cell> cells = this.tableCells(cube.cell(name));
        if (this.areInvalid(cells)) {
            return null;
        }
        return new Table.Row(this.insight.translate(name)).cells(cells).onClick(this.action(name, node)).onMicrosite(this.micrositeAction(node, slices));
    }

    private List<Table.Cell> tableCells(Cube.Cell cell) {
        return Arrays.stream(this.insight.indicators()).map(i -> CubesHelper.indicatorOf(cell, i)).map(this::tableCell).collect(Collectors.toList());
    }

    private Table.Cell tableCell(Cube.Indicator indicator) {
        return new Table.Cell(indicator.name(), this.value(indicator), indicator.units()).format(this.formatter(indicator));
    }

    private boolean areInvalid(List<Table.Cell> cells) {
        return cells.stream().allMatch(cell -> {
            Object object = cell.value();
            if (cell.isNumeric()) {
                Double value = (Double)object;
                return value == 0.0 || value.equals(Double.NaN) || value.longValue() == Long.MAX_VALUE || value.longValue() == Long.MIN_VALUE;
            }
            return object == null || object == LocalDate.MAX || object == LocalDate.MIN || object == LocalTime.MAX || object == LocalTime.MIN;
        });
    }

    private boolean containAllDimensions(Cube.Cell cell) {
        List cellDimensions = cell.slices().stream().map(s -> s.dimension().name().toLowerCase()).collect(Collectors.toList());
        return Arrays.stream(this.insight.dimensions()).allMatch(d -> cellDimensions.contains(d.toLowerCase()));
    }

    private List<Slice> slices(Cube cube, Node node) {
        return node.children().stream().map(Node::name).map(arg_0 -> ((Cube)cube).cell(arg_0)).filter(Objects::nonNull).flatMap(c -> c.slices().stream()).collect(Collectors.toList());
    }

    private List<Slice> slices(Cube cube) {
        return cube.dimensions().stream().flatMap(d -> d.slices(this.level()).stream()).collect(Collectors.toList());
    }

    private boolean slicesMatchLevel(Cube.Cell cell) {
        return this.isNotCustomLevel() || cell.slices().stream().allMatch(this::sliceMatchLevel);
    }

    private boolean sliceMatchLevel(Slice slice) {
        return slice.dimension().levels() <= 1 || slice.level() == this.insight.level().intValue();
    }

    private int level() {
        return this.insight.level() != null ? this.insight.level() : 100;
    }

    private String action(String name, Node node) {
        return this.isNavigable(node) && !this.isCustomNode() ? TableBuilder.openNodeAction(name) : null;
    }

    public static String openNodeAction(String name) {
        return "javascript:openNode('" + name + "')";
    }

    private String micrositeAction(Node node, Slice ... slices) {
        return this.microsite.action(node, slices);
    }

    private Formatter formatter(Cube.Indicator indicator) {
        return this.report.formatter(this.insight.format(indicator.name()));
    }

    private Object value(Cube.Indicator indicator) {
        Object value = indicator.value();
        if (value instanceof LocalTime || value instanceof LocalDate) {
            return value;
        }
        return CubesHelper.doubleValueOf(indicator);
    }

    private boolean isNavigable(Node node) {
        return node.dimension() != null && this.insight.dimensions().length == 1 && this.insight.dimensions()[0].equalsIgnoreCase(node.dimension());
    }

    private boolean isNotCustomLevel() {
        return this.insight.level() == null;
    }

    private boolean isCustomNode() {
        return this.insight.node() != null;
    }
}

