/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.builders;

import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.Node;
import io.intino.sumus.reporting.helpers.FormatHelper;
import io.intino.sumus.reporting.model.Visibility;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class NavigationBuilder {
    private final Dashboard.Report report;
    private final Visibility visibility;

    public NavigationBuilder(Dashboard.Report report) {
        this.report = report;
        this.visibility = report.visibility();
    }

    public String build(Node node) {
        return "<aside class=\"top-info\">" + this.navTag(node) + "</aside>";
    }

    private String navTag(Node node) {
        return "<div style=\"display: flex;align-items: center;\"><h3 style=\"display: flex;align-items: center;\" class=\"MuiTypography-root MuiTypography-h3 ReportingTypo ReportingTypo-h3\">" + this.reportNameTag(node) + ". " + this.reportDescriptionTag() + this.navigationTag(node) + this.selectTag(node) + "</h3></div>";
    }

    private String reportNameTag(Node node) {
        return node.isMain() ? FormatHelper.translationMark(this.report.label()) : "<a onclick=\"" + this.openNodeAction("_All") + "\" class=\"admin\">" + FormatHelper.translationMark(this.report.label()) + "</a>";
    }

    private String reportDescriptionTag() {
        String description = this.report.description();
        return description != null && !description.isEmpty() ? "<button class=\"description-icon\" title=\"" + FormatHelper.translationMark(description) + "\"></button>" : "";
    }

    private String navigationTag(Node node) {
        if (node.name().isEmpty()) {
            return "";
        }
        String parent = node.parent() != null ? node.parent().name() : "";
        String name = node.name().replace(parent, "");
        return "<a class=\"navigation-node\" onclick=\"" + this.openNodeAction(parent) + "\">" + parent + "</a>" + name;
    }

    private String selectTag(Node node) {
        if (this.areChildrenNotVisible(node)) {
            return "";
        }
        return "<select onchange=\"" + this.openNodeActionRaw("this.value") + "\"><option value='' selected></option>" + this.optionTags(node.children()) + "</select>";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean areChildrenNotVisible(Node node) {
        if (node.children().isEmpty()) return true;
        if (!node.children().stream().noneMatch(this.visibility::isVisible)) return false;
        return true;
    }

    private String optionTags(List<Node> nodes) {
        return nodes.stream().filter(n -> !n.name().isEmpty()).sorted(Comparator.comparing(Node::name)).map(this::optionTag).collect(Collectors.joining(""));
    }

    private String optionTag(Node node) {
        String parent = node.parent() != null ? node.parent().name() + "." : "";
        String subName = node.name().replace(parent, "");
        return "<option value='" + node.name() + "'>" + subName + "</option>";
    }

    private String openNodeAction(String name) {
        return this.openNodeActionRaw("'" + name + "'");
    }

    private String openNodeActionRaw(String name) {
        return "javascript:openNode(" + name + ")";
    }
}

