/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.builders;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Fact;
import io.intino.sumus.engine.dimensions.Category;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.Node;
import io.intino.sumus.reporting.builders.UIBuilder;
import io.intino.sumus.reporting.builders.schemas.List;
import io.intino.sumus.reporting.builders.templates.Renderer;
import io.intino.sumus.reporting.helpers.FormatHelper;
import io.intino.sumus.reporting.insights.ListInsight;
import java.util.Map;

public class ListBuilder
implements UIBuilder {
    private final ListInsight insight;
    private final Map<String, String> prefixes;

    public ListBuilder(Dashboard.Insight insight) {
        this.insight = new ListInsight(insight);
        this.prefixes = this.insight.prefixes();
    }

    @Override
    public String build(Cube cube, Node node) {
        List list = new List(this.insight.id());
        for (Fact fact : cube.facts()) {
            List.Item item = this.item(fact);
            if (item.isEmpty()) continue;
            list.add(item);
        }
        list.sortBy(this.insight.order());
        return Renderer.render(list);
    }

    private List.Item item(Fact fact) {
        List.Item item = new List.Item();
        for (String attribute : this.insight.attributes()) {
            Object object = fact.value(attribute);
            if (object == null) continue;
            item.add(attribute, this.valueOf(object), this.prefix(attribute));
        }
        return item;
    }

    private String valueOf(Object object) {
        if (object instanceof Category) {
            return ((Category)object).label;
        }
        return String.valueOf(object);
    }

    private String prefix(String attribute) {
        String prefix = this.prefixes.get(attribute);
        return prefix != null ? FormatHelper.translationMark(prefix) + " " : "";
    }
}

