/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.reporting.builders;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.reporting.Dashboard;
import io.intino.sumus.reporting.Node;
import io.intino.sumus.reporting.builders.MicrositeActionBuilder;
import io.intino.sumus.reporting.builders.UIBuilder;
import io.intino.sumus.reporting.builders.schemas.GaugeChart;
import io.intino.sumus.reporting.builders.templates.Renderer;
import io.intino.sumus.reporting.helpers.CubesHelper;
import io.intino.sumus.reporting.helpers.FormatHelper;

public class GaugeChartBuilder
implements UIBuilder {
    private final Dashboard.Insight insight;
    private final MicrositeActionBuilder microsite;

    public GaugeChartBuilder(Dashboard.Insight insight, MicrositeActionBuilder microsite) {
        this.insight = insight;
        this.microsite = microsite;
    }

    @Override
    public String build(Cube cube, Node node) {
        GaugeChart gauge = new GaugeChart(this.insight.id(), this.insight.label()).value(this.value(cube)).onClick(this.onClickAction(node));
        return Renderer.render(gauge);
    }

    private Double value(Cube cube) {
        Cube.Cell cell = cube.cell("");
        Cube.Indicator indicator = CubesHelper.indicatorOf(cell, this.firstIndicator());
        return FormatHelper.round(CubesHelper.doubleValueOf(indicator), 1);
    }

    private String firstIndicator() {
        return this.insight.indicators()[0];
    }

    private String onClickAction(Node node) {
        return this.microsite.action(node, new Slice[0]);
    }
}

