/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.model;

import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.IntegerLoader;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.tags.Terminal;
import io.intino.sumus.model.SumusGraph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class WeekCalendar
extends Layer
implements Terminal {
    protected List<Year> yearList = new ArrayList<Year>();

    public WeekCalendar(Node node) {
        super(node);
    }

    public List<Year> yearList() {
        return Collections.unmodifiableList(this.yearList);
    }

    public Year year(int index) {
        return this.yearList.get(index);
    }

    public List<Year> yearList(Predicate<Year> predicate) {
        return this.yearList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Year year(Predicate<Year> predicate) {
        return this.yearList().stream().filter(predicate).findFirst().orElse(null);
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Year>(this.yearList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("WeekCalendar$Year")) {
            this.yearList.add((Year)node.as(Year.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("WeekCalendar$Year")) {
            this.yearList.remove(node.as(Year.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public SumusGraph graph() {
        return (SumusGraph)this.core$().graph().as(SumusGraph.class);
    }

    public static class Year
    extends Layer
    implements Terminal {
        protected int year;
        protected List<Week> weekList = new ArrayList<Week>();

        public Year(Node node) {
            super(node);
        }

        public int year() {
            return this.year;
        }

        public Year year(int value) {
            this.year = value;
            return this;
        }

        public List<Week> weekList() {
            return Collections.unmodifiableList(this.weekList);
        }

        public Week week(int index) {
            return this.weekList.get(index);
        }

        public List<Week> weekList(Predicate<Week> predicate) {
            return this.weekList().stream().filter(predicate).collect(Collectors.toList());
        }

        public Week week(Predicate<Week> predicate) {
            return this.weekList().stream().filter(predicate).findFirst().orElse(null);
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Week>(this.weekList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("year", new ArrayList<Integer>(Collections.singletonList(this.year)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("WeekCalendar$Year$Week")) {
                this.weekList.add((Week)node.as(Week.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("WeekCalendar$Year$Week")) {
                this.weekList.remove(node.as(Week.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("year")) {
                this.year = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("year")) {
                this.year = (Integer)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public static class Week
        extends Layer
        implements Terminal {
            protected int weekNumber;
            protected String date;

            public Week(Node node) {
                super(node);
            }

            public int weekNumber() {
                return this.weekNumber;
            }

            public String date() {
                return this.date;
            }

            public Week weekNumber(int value) {
                this.weekNumber = value;
                return this;
            }

            public Week date(String value) {
                this.date = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("weekNumber", new ArrayList<Integer>(Collections.singletonList(this.weekNumber)));
                map.put("date", new ArrayList<String>(Collections.singletonList(this.date)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("weekNumber")) {
                    this.weekNumber = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("date")) {
                    this.date = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("weekNumber")) {
                    this.weekNumber = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("date")) {
                    this.date = (String)values.get(0);
                }
            }

            public SumusGraph graph() {
                return (SumusGraph)this.core$().graph().as(SumusGraph.class);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Week week(int weekNumber, String date) {
                Week newElement = (Week)Year.this.core$().graph().concept(Week.class).createNode(this.name, Year.this.core$()).as(Week.class);
                newElement.core$().set((Layer)newElement, "weekNumber", Collections.singletonList(weekNumber));
                newElement.core$().set((Layer)newElement, "date", Collections.singletonList(date));
                return newElement;
            }
        }

        public class Clear {
            public void week(Predicate<Week> filter) {
                new ArrayList<Week>(Year.this.weekList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Year year(int year) {
            Year newElement = (Year)WeekCalendar.this.core$().graph().concept(Year.class).createNode(this.name, WeekCalendar.this.core$()).as(Year.class);
            newElement.core$().set((Layer)newElement, "year", Collections.singletonList(year));
            return newElement;
        }
    }

    public class Clear {
        public void year(Predicate<Year> filter) {
            new ArrayList<Year>(WeekCalendar.this.yearList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }
}

