/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.model;

import io.intino.magritte.framework.Graph;
import io.intino.magritte.framework.Store;
import io.intino.magritte.io.model.Stash;
import io.intino.sumus.model.AbstractGraph;
import io.intino.sumus.model.Cube;
import io.intino.sumus.model.From;
import io.intino.sumus.model.Range;
import io.intino.sumus.model.RangeBoundary;
import io.intino.sumus.model.To;
import java.util.ArrayList;
import java.util.List;

public class SumusGraph
extends AbstractGraph {
    public SumusGraph(Graph graph) {
        super(graph);
    }

    public SumusGraph(Graph graph, SumusGraph wrapper) {
        super(graph, wrapper);
    }

    public List<Cube> cubeList() {
        return this.baseCubeList().stream().flatMap(m -> m.cubeList().stream()).toList();
    }

    public List<Range> cubeRangeFilters() {
        return this.cubeList().stream().flatMap(c -> c.datesFilterList().stream()).toList();
    }

    public List<RangeBoundary.BoundaryType> cubeRangeBoundaries() {
        ArrayList<RangeBoundary.BoundaryType> ranges = new ArrayList<RangeBoundary.BoundaryType>();
        for (Range range : this.cubeRangeFilters()) {
            From from = range.from();
            To to = range.to();
            if (from != null && from.isBoundaryType()) {
                ranges.add(from.asBoundaryType());
            }
            if (to == null || !to.isBoundaryType()) continue;
            ranges.add(to.asBoundaryType());
        }
        return ranges;
    }

    public static SumusGraph load(Stash ... startingModel) {
        return (SumusGraph)new Graph().loadLanguage("Sumus", SumusGraph._language()).loadStashes(startingModel).as(SumusGraph.class);
    }

    public static SumusGraph load(Store store, Stash ... startingModel) {
        return (SumusGraph)new Graph(store).loadLanguage("Sumus", SumusGraph._language()).loadStashes(startingModel).as(SumusGraph.class);
    }

    public static SumusGraph load(String ... startingModel) {
        return (SumusGraph)new Graph().loadLanguage("Sumus", SumusGraph._language()).loadStashes(startingModel).as(SumusGraph.class);
    }

    public static SumusGraph load(Store store, String ... startingModel) {
        return (SumusGraph)new Graph(store).loadLanguage("Sumus", SumusGraph._language()).loadStashes(startingModel).as(SumusGraph.class);
    }
}

