/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.model;

import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.tags.Terminal;
import io.intino.sumus.model.SumusGraph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Dictionary
extends Layer
implements Terminal {
    protected String language;
    protected List<Translation> translationList = new ArrayList<Translation>();

    public Dictionary(Node node) {
        super(node);
    }

    public String language() {
        return this.language;
    }

    public Dictionary language(String value) {
        this.language = value;
        return this;
    }

    public List<Translation> translationList() {
        return Collections.unmodifiableList(this.translationList);
    }

    public Translation translation(int index) {
        return this.translationList.get(index);
    }

    public List<Translation> translationList(Predicate<Translation> predicate) {
        return this.translationList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Translation translation(Predicate<Translation> predicate) {
        return this.translationList().stream().filter(predicate).findFirst().orElse(null);
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Translation>(this.translationList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("language", new ArrayList<String>(Collections.singletonList(this.language)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Dictionary$Translation")) {
            this.translationList.add((Translation)node.as(Translation.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Dictionary$Translation")) {
            this.translationList.remove(node.as(Translation.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("language")) {
            this.language = (String)StringLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("language")) {
            this.language = (String)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public SumusGraph graph() {
        return (SumusGraph)this.core$().graph().as(SumusGraph.class);
    }

    public static class Translation
    extends Layer
    implements Terminal {
        protected String value;
        protected String translated;

        public Translation(Node node) {
            super(node);
        }

        public String value() {
            return this.value;
        }

        public String translated() {
            return this.translated;
        }

        public Translation value(String value) {
            this.value = value;
            return this;
        }

        public Translation translated(String value) {
            this.translated = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("value", new ArrayList<String>(Collections.singletonList(this.value)));
            map.put("translated", new ArrayList<String>(Collections.singletonList(this.translated)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("value")) {
                this.value = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("translated")) {
                this.translated = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("value")) {
                this.value = (String)values.get(0);
            } else if (name.equalsIgnoreCase("translated")) {
                this.translated = (String)values.get(0);
            }
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Translation translation(String value, String translated) {
            Translation newElement = (Translation)Dictionary.this.core$().graph().concept(Translation.class).createNode(this.name, Dictionary.this.core$()).as(Translation.class);
            newElement.core$().set((Layer)newElement, "value", Collections.singletonList(value));
            newElement.core$().set((Layer)newElement, "translated", Collections.singletonList(translated));
            return newElement;
        }
    }

    public class Clear {
        public void translation(Predicate<Translation> filter) {
            new ArrayList<Translation>(Dictionary.this.translationList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }
}

