/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.model;

import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.loaders.NodeLoader;
import io.intino.magritte.framework.tags.Terminal;
import io.intino.sumus.model.Attribute;
import io.intino.sumus.model.Cube;
import io.intino.sumus.model.Filter;
import io.intino.sumus.model.Ledger;
import io.intino.sumus.model.Node;
import io.intino.sumus.model.Range;
import io.intino.sumus.model.Slice;
import io.intino.sumus.model.SumusGraph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class BaseCube
extends Layer
implements Terminal {
    protected Ledger ledger;
    protected List<Filter> filterList = new ArrayList<Filter>();
    protected List<Cube> cubeList = new ArrayList<Cube>();

    public BaseCube(io.intino.magritte.framework.Node node) {
        super(node);
    }

    public Ledger ledger() {
        return this.ledger;
    }

    public BaseCube ledger(Ledger value) {
        this.ledger = value;
        return this;
    }

    public List<Filter> filterList() {
        return Collections.unmodifiableList(this.filterList);
    }

    public Filter filter(int index) {
        return this.filterList.get(index);
    }

    public List<Filter> filterList(Predicate<Filter> predicate) {
        return this.filterList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Filter filter(Predicate<Filter> predicate) {
        return this.filterList().stream().filter(predicate).findFirst().orElse(null);
    }

    public List<Cube> cubeList() {
        return Collections.unmodifiableList(this.cubeList);
    }

    public Cube cube(int index) {
        return this.cubeList.get(index);
    }

    public List<Cube> cubeList(Predicate<Cube> predicate) {
        return this.cubeList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Cube cube(Predicate<Cube> predicate) {
        return this.cubeList().stream().filter(predicate).findFirst().orElse(null);
    }

    protected List<io.intino.magritte.framework.Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Filter>(this.filterList).forEach(c -> components.add(c.core$()));
        new ArrayList<Cube>(this.cubeList).forEach(c -> components.add(c.core$()));
        return new ArrayList<io.intino.magritte.framework.Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("ledger", this.ledger != null ? new ArrayList<Ledger>(Collections.singletonList(this.ledger)) : Collections.emptyList());
        return map;
    }

    protected void addNode$(io.intino.magritte.framework.Node node) {
        super.addNode$(node);
        if (node.is("Filter")) {
            this.filterList.add((Filter)node.as(Filter.class));
        }
        if (node.is("Cube")) {
            this.cubeList.add((Cube)node.as(Cube.class));
        }
    }

    protected void removeNode$(io.intino.magritte.framework.Node node) {
        super.removeNode$(node);
        if (node.is("Filter")) {
            this.filterList.remove(node.as(Filter.class));
        }
        if (node.is("Cube")) {
            this.cubeList.remove(node.as(Cube.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("ledger")) {
            this.ledger = (Ledger)((Object)NodeLoader.load(values, Ledger.class, (Layer)this).get(0));
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("ledger")) {
            this.ledger = values.get(0) != null ? (Ledger)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Ledger.class) : null;
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public SumusGraph graph() {
        return (SumusGraph)this.core$().graph().as(SumusGraph.class);
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Cube cube() {
            Cube newElement = (Cube)BaseCube.this.core$().graph().concept(Cube.class).createNode(this.name, BaseCube.this.core$()).as(Cube.class);
            return newElement;
        }

        public Slice slice(Attribute.Category attribute, String value) {
            Slice newElement = (Slice)BaseCube.this.core$().graph().concept(Slice.class).createNode(this.name, BaseCube.this.core$()).as(Slice.class);
            newElement.core$().set((Layer)newElement, "attribute", Collections.singletonList(attribute));
            newElement.core$().set((Layer)newElement, "value", Collections.singletonList(value));
            return newElement;
        }

        public Node node(Node.Type type) {
            Node newElement = (Node)BaseCube.this.core$().graph().concept(Node.class).createNode(this.name, BaseCube.this.core$()).as(Node.class);
            newElement.core$().set((Layer)newElement, "type", Collections.singletonList(type));
            return newElement;
        }

        public Range range(Attribute.Date attribute) {
            Range newElement = (Range)BaseCube.this.core$().graph().concept(Range.class).createNode(this.name, BaseCube.this.core$()).as(Range.class);
            newElement.core$().set((Layer)newElement, "attribute", Collections.singletonList(attribute));
            return newElement;
        }
    }

    public class Clear {
        public void cube(Predicate<Cube> filter) {
            new ArrayList<Cube>(BaseCube.this.cubeList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }
}

