/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.model;

import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.NodeLoader;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.tags.Terminal;
import io.intino.sumus.model.Attribute;
import io.intino.sumus.model.Indicator;
import io.intino.sumus.model.Ledger;
import io.intino.sumus.model.Storyboard;
import io.intino.sumus.model.SumusGraph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractStoryboard
extends Layer
implements Terminal {
    protected String id;
    protected String label;
    protected Ledger ledger;
    protected List<Storyboard.Measure> measureList = new ArrayList<Storyboard.Measure>();
    protected List<Storyboard.Dimension> dimensionList = new ArrayList<Storyboard.Dimension>();

    public AbstractStoryboard(Node node) {
        super(node);
    }

    public String id() {
        return this.id;
    }

    public String label() {
        return this.label;
    }

    public Ledger ledger() {
        return this.ledger;
    }

    public Storyboard id(String value) {
        this.id = value;
        return (Storyboard)this;
    }

    public Storyboard label(String value) {
        this.label = value;
        return (Storyboard)this;
    }

    public Storyboard ledger(Ledger value) {
        this.ledger = value;
        return (Storyboard)this;
    }

    public List<Storyboard.Measure> measureList() {
        return Collections.unmodifiableList(this.measureList);
    }

    public Storyboard.Measure measure(int index) {
        return this.measureList.get(index);
    }

    public List<Storyboard.Measure> measureList(Predicate<Storyboard.Measure> predicate) {
        return this.measureList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Storyboard.Measure measure(Predicate<Storyboard.Measure> predicate) {
        return this.measureList().stream().filter(predicate).findFirst().orElse(null);
    }

    public List<Storyboard.Dimension> dimensionList() {
        return Collections.unmodifiableList(this.dimensionList);
    }

    public Storyboard.Dimension dimension(int index) {
        return this.dimensionList.get(index);
    }

    public List<Storyboard.Dimension> dimensionList(Predicate<Storyboard.Dimension> predicate) {
        return this.dimensionList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Storyboard.Dimension dimension(Predicate<Storyboard.Dimension> predicate) {
        return this.dimensionList().stream().filter(predicate).findFirst().orElse(null);
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Storyboard.Measure>(this.measureList).forEach(c -> components.add(c.core$()));
        new ArrayList<Storyboard.Dimension>(this.dimensionList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("id", new ArrayList<String>(Collections.singletonList(this.id)));
        map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
        map.put("ledger", this.ledger != null ? new ArrayList<Ledger>(Collections.singletonList(this.ledger)) : Collections.emptyList());
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Storyboard$Measure")) {
            this.measureList.add((Storyboard.Measure)node.as(Storyboard.Measure.class));
        }
        if (node.is("Storyboard$Dimension")) {
            this.dimensionList.add((Storyboard.Dimension)node.as(Storyboard.Dimension.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Storyboard$Measure")) {
            this.measureList.remove(node.as(Storyboard.Measure.class));
        }
        if (node.is("Storyboard$Dimension")) {
            this.dimensionList.remove(node.as(Storyboard.Dimension.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("id")) {
            this.id = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("label")) {
            this.label = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("ledger")) {
            this.ledger = (Ledger)((Object)NodeLoader.load(values, Ledger.class, (Layer)this).get(0));
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("id")) {
            this.id = (String)values.get(0);
        } else if (name.equalsIgnoreCase("label")) {
            this.label = (String)values.get(0);
        } else if (name.equalsIgnoreCase("ledger")) {
            this.ledger = values.get(0) != null ? (Ledger)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Ledger.class) : null;
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public SumusGraph graph() {
        return (SumusGraph)this.core$().graph().as(SumusGraph.class);
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Storyboard.Measure measure(Indicator indicator, String label) {
            Storyboard.Measure newElement = (Storyboard.Measure)AbstractStoryboard.this.core$().graph().concept(Storyboard.Measure.class).createNode(this.name, AbstractStoryboard.this.core$()).as(Storyboard.Measure.class);
            newElement.core$().set((Layer)newElement, "indicator", Collections.singletonList(indicator));
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        public Storyboard.Dimension dimension(Attribute.Category attribute, String label) {
            Storyboard.Dimension newElement = (Storyboard.Dimension)AbstractStoryboard.this.core$().graph().concept(Storyboard.Dimension.class).createNode(this.name, AbstractStoryboard.this.core$()).as(Storyboard.Dimension.class);
            newElement.core$().set((Layer)newElement, "attribute", Collections.singletonList(attribute));
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }
    }

    public class Clear {
        public void measure(Predicate<Storyboard.Measure> filter) {
            new ArrayList<Storyboard.Measure>(AbstractStoryboard.this.measureList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void dimension(Predicate<Storyboard.Dimension> filter) {
            new ArrayList<Storyboard.Dimension>(AbstractStoryboard.this.dimensionList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public static abstract class AbstractDimension
    extends Layer
    implements Terminal {
        protected Attribute.Category attribute;
        protected String label;

        public AbstractDimension(Node node) {
            super(node);
        }

        public Attribute.Category attribute() {
            return this.attribute;
        }

        public String label() {
            return this.label;
        }

        public Storyboard.Dimension attribute(Attribute.Category value) {
            this.attribute = value;
            return (Storyboard.Dimension)this;
        }

        public Storyboard.Dimension label(String value) {
            this.label = value;
            return (Storyboard.Dimension)this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("attribute", this.attribute != null ? new ArrayList<Attribute.Category>(Collections.singletonList(this.attribute)) : Collections.emptyList());
            map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("attribute")) {
                this.attribute = (Attribute.Category)((Object)NodeLoader.load(values, Attribute.Category.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("label")) {
                this.label = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("attribute")) {
                this.attribute = values.get(0) != null ? (Attribute.Category)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Attribute.Category.class) : null;
            } else if (name.equalsIgnoreCase("label")) {
                this.label = (String)values.get(0);
            }
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }
    }

    public static abstract class AbstractMeasure
    extends Layer
    implements Terminal {
        protected Indicator indicator;
        protected String label;

        public AbstractMeasure(Node node) {
            super(node);
        }

        public Indicator indicator() {
            return this.indicator;
        }

        public String label() {
            return this.label;
        }

        public Storyboard.Measure indicator(Indicator value) {
            this.indicator = value;
            return (Storyboard.Measure)this;
        }

        public Storyboard.Measure label(String value) {
            this.label = value;
            return (Storyboard.Measure)this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("indicator", this.indicator != null ? new ArrayList<Indicator>(Collections.singletonList(this.indicator)) : Collections.emptyList());
            map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("indicator")) {
                this.indicator = (Indicator)((Object)NodeLoader.load(values, Indicator.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("label")) {
                this.label = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("indicator")) {
                this.indicator = values.get(0) != null ? (Indicator)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Indicator.class) : null;
            } else if (name.equalsIgnoreCase("label")) {
                this.label = (String)values.get(0);
            }
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }
    }
}

