/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.model;

import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.NodeLoader;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.loaders.WordLoader;
import io.intino.magritte.framework.tags.Terminal;
import io.intino.sumus.model.Attribute;
import io.intino.sumus.model.Dimension;
import io.intino.sumus.model.Indicator;
import io.intino.sumus.model.Ledger;
import io.intino.sumus.model.SumusGraph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractLedger
extends Layer
implements Terminal {
    protected String id;
    protected String label;
    protected String description;
    protected Format format;
    protected Content content;
    protected List<Attribute> attributeList = new ArrayList<Attribute>();
    protected List<Dimension> dimensionList = new ArrayList<Dimension>();
    protected List<Indicator> indicatorList = new ArrayList<Indicator>();
    protected Ledger.Aggregation _aggregation;

    public AbstractLedger(Node node) {
        super(node);
    }

    public String id() {
        return this.id;
    }

    public String label() {
        return this.label;
    }

    public String description() {
        return this.description;
    }

    public Format format() {
        return this.format;
    }

    public Content content() {
        return this.content;
    }

    public Ledger id(String value) {
        this.id = value;
        return (Ledger)this;
    }

    public Ledger label(String value) {
        this.label = value;
        return (Ledger)this;
    }

    public Ledger description(String value) {
        this.description = value;
        return (Ledger)this;
    }

    public Ledger format(Format value) {
        this.format = value;
        return (Ledger)this;
    }

    public Ledger content(Content value) {
        this.content = value;
        return (Ledger)this;
    }

    public List<Attribute> attributeList() {
        return Collections.unmodifiableList(this.attributeList);
    }

    public Attribute attribute(int index) {
        return this.attributeList.get(index);
    }

    public List<Attribute> attributeList(Predicate<Attribute> predicate) {
        return this.attributeList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Attribute attribute(Predicate<Attribute> predicate) {
        return this.attributeList().stream().filter(predicate).findFirst().orElse(null);
    }

    public List<Dimension> dimensionList() {
        return Collections.unmodifiableList(this.dimensionList);
    }

    public Dimension dimension(int index) {
        return this.dimensionList.get(index);
    }

    public List<Dimension> dimensionList(Predicate<Dimension> predicate) {
        return this.dimensionList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Dimension dimension(Predicate<Dimension> predicate) {
        return this.dimensionList().stream().filter(predicate).findFirst().orElse(null);
    }

    public List<Indicator> indicatorList() {
        return Collections.unmodifiableList(this.indicatorList);
    }

    public Indicator indicator(int index) {
        return this.indicatorList.get(index);
    }

    public List<Indicator> indicatorList(Predicate<Indicator> predicate) {
        return this.indicatorList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Indicator indicator(Predicate<Indicator> predicate) {
        return this.indicatorList().stream().filter(predicate).findFirst().orElse(null);
    }

    public Ledger.Aggregation asAggregation() {
        return (Ledger.Aggregation)this.a$(Ledger.Aggregation.class);
    }

    public Ledger.Aggregation asAggregation(Ledger baseLedger, AbstractAggregation.AggregationPeriod aggregationPeriod) {
        Ledger.Aggregation newElement = (Ledger.Aggregation)this.core$().addAspect(Ledger.Aggregation.class);
        newElement.core$().set((Layer)newElement, "baseLedger", Collections.singletonList(baseLedger));
        newElement.core$().set((Layer)newElement, "aggregationPeriod", Collections.singletonList(aggregationPeriod));
        return newElement;
    }

    public boolean isAggregation() {
        return this.core$().is(Ledger.Aggregation.class);
    }

    public void removeAggregation() {
        this.core$().removeAspect(Ledger.Aggregation.class);
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Attribute>(this.attributeList).forEach(c -> components.add(c.core$()));
        new ArrayList<Dimension>(this.dimensionList).forEach(c -> components.add(c.core$()));
        new ArrayList<Indicator>(this.indicatorList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("id", new ArrayList<String>(Collections.singletonList(this.id)));
        map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
        map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
        map.put("format", new ArrayList<Format>(Collections.singletonList(this.format)));
        map.put("content", new ArrayList<Content>(Collections.singletonList(this.content)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Attribute")) {
            this.attributeList.add((Attribute)node.as(Attribute.class));
        }
        if (node.is("Dimension")) {
            this.dimensionList.add((Dimension)node.as(Dimension.class));
        }
        if (node.is("Indicator")) {
            this.indicatorList.add((Indicator)node.as(Indicator.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Attribute")) {
            this.attributeList.remove(node.as(Attribute.class));
        }
        if (node.is("Dimension")) {
            this.dimensionList.remove(node.as(Dimension.class));
        }
        if (node.is("Indicator")) {
            this.indicatorList.remove(node.as(Indicator.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("id")) {
            this.id = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("label")) {
            this.label = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("description")) {
            this.description = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("format")) {
            this.format = (Format)((Object)WordLoader.load(values, Format.class, (Layer)this).get(0));
        } else if (name.equalsIgnoreCase("content")) {
            this.content = (Content)((Object)WordLoader.load(values, Content.class, (Layer)this).get(0));
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("id")) {
            this.id = (String)values.get(0);
        } else if (name.equalsIgnoreCase("label")) {
            this.label = (String)values.get(0);
        } else if (name.equalsIgnoreCase("description")) {
            this.description = (String)values.get(0);
        } else if (name.equalsIgnoreCase("format")) {
            this.format = (Format)((Object)values.get(0));
        } else if (name.equalsIgnoreCase("content")) {
            this.content = (Content)((Object)values.get(0));
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public SumusGraph graph() {
        return (SumusGraph)this.core$().graph().as(SumusGraph.class);
    }

    public static enum Format {
        TSV;

    }

    public static enum Content {
        Status,
        Events,
        Master;

    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Attribute attribute() {
            Attribute newElement = (Attribute)AbstractLedger.this.core$().graph().concept(Attribute.class).createNode(this.name, AbstractLedger.this.core$()).as(Attribute.class);
            return newElement;
        }

        public Dimension dimension() {
            Dimension newElement = (Dimension)AbstractLedger.this.core$().graph().concept(Dimension.class).createNode(this.name, AbstractLedger.this.core$()).as(Dimension.class);
            return newElement;
        }

        public Indicator indicator() {
            Indicator newElement = (Indicator)AbstractLedger.this.core$().graph().concept(Indicator.class).createNode(this.name, AbstractLedger.this.core$()).as(Indicator.class);
            return newElement;
        }
    }

    public class Clear {
        public void attribute(Predicate<Attribute> filter) {
            new ArrayList<Attribute>(AbstractLedger.this.attributeList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void dimension(Predicate<Dimension> filter) {
            new ArrayList<Dimension>(AbstractLedger.this.dimensionList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void indicator(Predicate<Indicator> filter) {
            new ArrayList<Indicator>(AbstractLedger.this.indicatorList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public static abstract class AbstractAggregation
    extends Layer
    implements Terminal {
        protected Ledger baseLedger;
        protected AggregationPeriod aggregationPeriod;
        protected Attribute aggregationKey;
        protected Ledger _ledger;

        public AbstractAggregation(Node node) {
            super(node);
        }

        public Ledger baseLedger() {
            return this.baseLedger;
        }

        public AggregationPeriod aggregationPeriod() {
            return this.aggregationPeriod;
        }

        public Attribute aggregationKey() {
            return this.aggregationKey;
        }

        public String id() {
            return this._ledger.id();
        }

        public String label() {
            return this._ledger.label();
        }

        public String description() {
            return this._ledger.description();
        }

        public Format format() {
            return this._ledger.format();
        }

        public Content content() {
            return this._ledger.content();
        }

        public Ledger.Aggregation baseLedger(Ledger value) {
            this.baseLedger = value;
            return (Ledger.Aggregation)this;
        }

        public Ledger.Aggregation aggregationPeriod(AggregationPeriod value) {
            this.aggregationPeriod = value;
            return (Ledger.Aggregation)this;
        }

        public Ledger.Aggregation aggregationKey(Attribute value) {
            this.aggregationKey = value;
            return (Ledger.Aggregation)this;
        }

        public Ledger.Aggregation id(String value) {
            this._ledger.id(value);
            return (Ledger.Aggregation)this;
        }

        public Ledger.Aggregation label(String value) {
            this._ledger.label(value);
            return (Ledger.Aggregation)this;
        }

        public Ledger.Aggregation description(String value) {
            this._ledger.description(value);
            return (Ledger.Aggregation)this;
        }

        public Ledger.Aggregation format(Format value) {
            this._ledger.format(value);
            return (Ledger.Aggregation)this;
        }

        public Ledger.Aggregation content(Content value) {
            this._ledger.content(value);
            return (Ledger.Aggregation)this;
        }

        public List<Attribute> attributeList() {
            return this._ledger.attributeList();
        }

        public Attribute attributeList(int index) {
            return this._ledger.attributeList().get(index);
        }

        public List<Dimension> dimensionList() {
            return this._ledger.dimensionList();
        }

        public Dimension dimensionList(int index) {
            return this._ledger.dimensionList().get(index);
        }

        public List<Indicator> indicatorList() {
            return this._ledger.indicatorList();
        }

        public Indicator indicatorList(int index) {
            return this._ledger.indicatorList().get(index);
        }

        public Ledger asLedger() {
            return (Ledger)this.a$(Ledger.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("baseLedger", this.baseLedger != null ? new ArrayList<Ledger>(Collections.singletonList(this.baseLedger)) : Collections.emptyList());
            map.put("aggregationPeriod", new ArrayList<AggregationPeriod>(Collections.singletonList(this.aggregationPeriod)));
            map.put("aggregationKey", this.aggregationKey != null ? new ArrayList<Attribute>(Collections.singletonList(this.aggregationKey)) : Collections.emptyList());
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("baseLedger")) {
                this.baseLedger = (Ledger)((Object)NodeLoader.load(values, Ledger.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("aggregationPeriod")) {
                this.aggregationPeriod = (AggregationPeriod)((Object)WordLoader.load(values, AggregationPeriod.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("aggregationKey")) {
                this.aggregationKey = (Attribute)((Object)NodeLoader.load(values, Attribute.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("baseLedger")) {
                this.baseLedger = values.get(0) != null ? (Ledger)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Ledger.class) : null;
            } else if (name.equalsIgnoreCase("aggregationPeriod")) {
                this.aggregationPeriod = (AggregationPeriod)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("aggregationKey")) {
                this.aggregationKey = values.get(0) != null ? (Attribute)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Attribute.class) : null;
            }
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Ledger) {
                this._ledger = (Ledger)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public static enum AggregationPeriod {
            Week,
            Month,
            Quarter,
            Year;

        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Attribute attribute() {
                Attribute newElement = (Attribute)AbstractAggregation.this.core$().graph().concept(Attribute.class).createNode(this.name, AbstractAggregation.this.core$()).as(Attribute.class);
                return newElement;
            }

            public Dimension dimension() {
                Dimension newElement = (Dimension)AbstractAggregation.this.core$().graph().concept(Dimension.class).createNode(this.name, AbstractAggregation.this.core$()).as(Dimension.class);
                return newElement;
            }

            public Indicator indicator() {
                Indicator newElement = (Indicator)AbstractAggregation.this.core$().graph().concept(Indicator.class).createNode(this.name, AbstractAggregation.this.core$()).as(Indicator.class);
                return newElement;
            }
        }

        public class Clear {
            public void attribute(Predicate<Attribute> filter) {
                new ArrayList<Attribute>(AbstractAggregation.this.attributeList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void dimension(Predicate<Dimension> filter) {
                new ArrayList<Dimension>(AbstractAggregation.this.dimensionList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void indicator(Predicate<Indicator> filter) {
                new ArrayList<Indicator>(AbstractAggregation.this.indicatorList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }
    }
}

