/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.model;

import io.intino.magritte.framework.Concept;
import io.intino.magritte.framework.Graph;
import io.intino.magritte.framework.GraphWrapper;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.utils.I18n;
import io.intino.magritte.io.StashDeserializer;
import io.intino.magritte.io.model.Stash;
import io.intino.sumus.model.AbstractLedger;
import io.intino.sumus.model.BaseCube;
import io.intino.sumus.model.Classifiable;
import io.intino.sumus.model.Dashboard;
import io.intino.sumus.model.Dictionary;
import io.intino.sumus.model.Ledger;
import io.intino.sumus.model.Numerical;
import io.intino.sumus.model.Period;
import io.intino.sumus.model.RangeBoundary;
import io.intino.sumus.model.Report;
import io.intino.sumus.model.Storyboard;
import io.intino.sumus.model.Translatable;
import io.intino.sumus.model.WeekCalendar;
import io.intino.sumus.model.rules.Scale;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class AbstractGraph
extends GraphWrapper {
    protected Graph graph;
    private WeekCalendar weekCalendar;
    private List<BaseCube> baseCubeList = new ArrayList<BaseCube>();
    private List<RangeBoundary> rangeBoundaryList = new ArrayList<RangeBoundary>();
    private List<Dashboard> dashboardList = new ArrayList<Dashboard>();
    private List<Dictionary> dictionaryList = new ArrayList<Dictionary>();
    private List<Translatable> translatableList = new ArrayList<Translatable>();
    private List<Ledger> ledgerList = new ArrayList<Ledger>();
    private List<Numerical> numericalList = new ArrayList<Numerical>();
    private List<Classifiable> classifiableList = new ArrayList<Classifiable>();
    private List<Report> reportList = new ArrayList<Report>();
    private List<Period> periodList = new ArrayList<Period>();
    private List<Storyboard> storyboardList = new ArrayList<Storyboard>();
    private Map<String, Indexer> _index = this._fillIndex();

    public AbstractGraph(Graph graph) {
        this.graph = graph;
        this.graph.i18n().register("Sumus");
    }

    public AbstractGraph(Graph graph, AbstractGraph wrapper) {
        this.graph = graph;
        this.graph.i18n().register("Sumus");
        this.weekCalendar = wrapper.weekCalendar;
        this.baseCubeList = new ArrayList<BaseCube>(wrapper.baseCubeList);
        this.rangeBoundaryList = new ArrayList<RangeBoundary>(wrapper.rangeBoundaryList);
        this.dashboardList = new ArrayList<Dashboard>(wrapper.dashboardList);
        this.dictionaryList = new ArrayList<Dictionary>(wrapper.dictionaryList);
        this.translatableList = new ArrayList<Translatable>(wrapper.translatableList);
        this.ledgerList = new ArrayList<Ledger>(wrapper.ledgerList);
        this.numericalList = new ArrayList<Numerical>(wrapper.numericalList);
        this.classifiableList = new ArrayList<Classifiable>(wrapper.classifiableList);
        this.reportList = new ArrayList<Report>(wrapper.reportList);
        this.periodList = new ArrayList<Period>(wrapper.periodList);
        this.storyboardList = new ArrayList<Storyboard>(wrapper.storyboardList);
    }

    public <T extends GraphWrapper> T a$(Class<T> t) {
        return (T)this.core$().as(t);
    }

    public void update() {
        this._index.values().forEach(v -> v.clear());
        this.graph.rootList().forEach(r -> this.addNode$((Node)r));
    }

    protected void addNode$(Node node) {
        for (Concept c : node.conceptList()) {
            if (!this._index.containsKey(c.id())) continue;
            this._index.get(c.id()).add(node);
        }
        if (this._index.containsKey(node.id())) {
            this._index.get(node.id()).add(node);
        }
    }

    protected void removeNode$(Node node) {
        for (Concept c : node.conceptList()) {
            if (!this._index.containsKey(c.id())) continue;
            this._index.get(c.id()).remove(node);
        }
        if (this._index.containsKey(node.id())) {
            this._index.get(node.id()).remove(node);
        }
    }

    public URL resourceAsMessage$(String language, String key) {
        return this.graph.loadResource(this.graph.i18n().message(language, key, new Object[0]));
    }

    public WeekCalendar weekCalendar() {
        return this.weekCalendar;
    }

    public List<BaseCube> baseCubeList() {
        return this.baseCubeList;
    }

    public List<RangeBoundary> rangeBoundaryList() {
        return this.rangeBoundaryList;
    }

    public List<Dashboard> dashboardList() {
        return this.dashboardList;
    }

    public List<Dictionary> dictionaryList() {
        return this.dictionaryList;
    }

    public List<Translatable> translatableList() {
        return this.translatableList;
    }

    public List<Ledger> ledgerList() {
        return this.ledgerList;
    }

    public List<Numerical> numericalList() {
        return this.numericalList;
    }

    public List<Classifiable> classifiableList() {
        return this.classifiableList;
    }

    public List<Report> reportList() {
        return this.reportList;
    }

    public List<Period> periodList() {
        return this.periodList;
    }

    public List<Storyboard> storyboardList() {
        return this.storyboardList;
    }

    public Stream<BaseCube> baseCubeList(Predicate<BaseCube> filter) {
        return this.baseCubeList.stream().filter(filter);
    }

    public BaseCube baseCube(int index) {
        return this.baseCubeList.get(index);
    }

    public Stream<RangeBoundary> rangeBoundaryList(Predicate<RangeBoundary> filter) {
        return this.rangeBoundaryList.stream().filter(filter);
    }

    public RangeBoundary rangeBoundary(int index) {
        return this.rangeBoundaryList.get(index);
    }

    public Stream<Dashboard> dashboardList(Predicate<Dashboard> filter) {
        return this.dashboardList.stream().filter(filter);
    }

    public Dashboard dashboard(int index) {
        return this.dashboardList.get(index);
    }

    public Stream<Dictionary> dictionaryList(Predicate<Dictionary> filter) {
        return this.dictionaryList.stream().filter(filter);
    }

    public Dictionary dictionary(int index) {
        return this.dictionaryList.get(index);
    }

    public Stream<Translatable> translatableList(Predicate<Translatable> filter) {
        return this.translatableList.stream().filter(filter);
    }

    public Translatable translatable(int index) {
        return this.translatableList.get(index);
    }

    public Stream<Ledger> ledgerList(Predicate<Ledger> filter) {
        return this.ledgerList.stream().filter(filter);
    }

    public Ledger ledger(int index) {
        return this.ledgerList.get(index);
    }

    public Stream<Numerical> numericalList(Predicate<Numerical> filter) {
        return this.numericalList.stream().filter(filter);
    }

    public Numerical numerical(int index) {
        return this.numericalList.get(index);
    }

    public Stream<Classifiable> classifiableList(Predicate<Classifiable> filter) {
        return this.classifiableList.stream().filter(filter);
    }

    public Classifiable classifiable(int index) {
        return this.classifiableList.get(index);
    }

    public Stream<Report> reportList(Predicate<Report> filter) {
        return this.reportList.stream().filter(filter);
    }

    public Report report(int index) {
        return this.reportList.get(index);
    }

    public Stream<Period> periodList(Predicate<Period> filter) {
        return this.periodList.stream().filter(filter);
    }

    public Period period(int index) {
        return this.periodList.get(index);
    }

    public Stream<Storyboard> storyboardList(Predicate<Storyboard> filter) {
        return this.storyboardList.stream().filter(filter);
    }

    public Storyboard storyboard(int index) {
        return this.storyboardList.get(index);
    }

    public Graph core$() {
        return this.graph;
    }

    public I18n i18n$() {
        return this.graph.i18n();
    }

    public Create create() {
        return new Create("Misc", null);
    }

    public Create create(String stash) {
        return new Create(stash, null);
    }

    public Create create(String stash, String name) {
        return new Create(stash, name);
    }

    public Clear clear() {
        return new Clear();
    }

    private HashMap<String, Indexer> _fillIndex() {
        HashMap<String, Indexer> map = new HashMap<String, Indexer>();
        map.put("WeekCalendar", new Indexer(node -> {
            this.weekCalendar = (WeekCalendar)node.as(WeekCalendar.class);
        }, node -> {
            this.weekCalendar = null;
        }, () -> {
            this.weekCalendar = null;
        }));
        map.put("BaseCube", new Indexer(node -> this.baseCubeList.add((BaseCube)node.as(BaseCube.class)), node -> this.baseCubeList.remove(node.as(BaseCube.class)), () -> this.baseCubeList.clear()));
        map.put("RangeBoundary", new Indexer(node -> this.rangeBoundaryList.add((RangeBoundary)node.as(RangeBoundary.class)), node -> this.rangeBoundaryList.remove(node.as(RangeBoundary.class)), () -> this.rangeBoundaryList.clear()));
        map.put("Dashboard", new Indexer(node -> this.dashboardList.add((Dashboard)node.as(Dashboard.class)), node -> this.dashboardList.remove(node.as(Dashboard.class)), () -> this.dashboardList.clear()));
        map.put("Dictionary", new Indexer(node -> this.dictionaryList.add((Dictionary)node.as(Dictionary.class)), node -> this.dictionaryList.remove(node.as(Dictionary.class)), () -> this.dictionaryList.clear()));
        map.put("Translatable", new Indexer(node -> this.translatableList.add((Translatable)node.as(Translatable.class)), node -> this.translatableList.remove(node.as(Translatable.class)), () -> this.translatableList.clear()));
        map.put("Ledger", new Indexer(node -> this.ledgerList.add((Ledger)node.as(Ledger.class)), node -> this.ledgerList.remove(node.as(Ledger.class)), () -> this.ledgerList.clear()));
        map.put("Numerical", new Indexer(node -> this.numericalList.add((Numerical)node.as(Numerical.class)), node -> this.numericalList.remove(node.as(Numerical.class)), () -> this.numericalList.clear()));
        map.put("Classifiable", new Indexer(node -> this.classifiableList.add((Classifiable)node.as(Classifiable.class)), node -> this.classifiableList.remove(node.as(Classifiable.class)), () -> this.classifiableList.clear()));
        map.put("Report", new Indexer(node -> this.reportList.add((Report)node.as(Report.class)), node -> this.reportList.remove(node.as(Report.class)), () -> this.reportList.clear()));
        map.put("Period", new Indexer(node -> this.periodList.add((Period)node.as(Period.class)), node -> this.periodList.remove(node.as(Period.class)), () -> this.periodList.clear()));
        map.put("Storyboard", new Indexer(node -> this.storyboardList.add((Storyboard)node.as(Storyboard.class)), node -> this.storyboardList.remove(node.as(Storyboard.class)), () -> this.storyboardList.clear()));
        return map;
    }

    public static Stash[] _language() {
        return new Stash[]{AbstractGraph.stash()};
    }

    private static Stash stash() {
        String content = AbstractGraph.stash0() + AbstractGraph.stash1() + AbstractGraph.stash2() + AbstractGraph.stash3();
        return StashDeserializer.stashFrom((byte[])Base64.getDecoder().decode(content));
    }

    private static String stash0() {
        return "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";
    }

    private static String stash1() {
        return "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";
    }

    private static String stash2() {
        return "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";
    }

    private static String stash3() {
        return "/v///w8AUGxvdExpbuUCAFJlcG9ydCRWaWV3Q2hhcnRzJFNlbGVjdG/yAgJSZXBvcnQkVmlld0NoYXJ0cyRUZW1wb3JhbGl0+QAAAABSZXBvcnQkTGluZVZpZfcBAAEBAAFSZXBvcnQkVGltZWxpbmVDaGFy9AEAAkNvbmNlcPQBAAGoaW8uaW50aW5vLnN1bXVzLm1vZGVsLlJlcG9ydCRDb2x1bW5WaWV3AQCEAQIA/v///w8AUGxvdExpbuUCAFJlcG9ydCRWaWV3Q2hhcnRzJFNlbGVjdG/yAgJSZXBvcnQkVmlld0NoYXJ0cyRUZW1wb3JhbGl0+QAAAABSZXBvcnQkQ29sdW1uVmll9wEAAQEAAVJlcG9ydCRUaW1lbGluZUNoYXL0AQACQ29uY2Vw9AEAAaxpby5pbnRpbm8uc3VtdXMubW9kZWwuUmVwb3J0JENvbHVtblN3YXBWaWV3AQCEAQIA/v///w8AUGxvdExpbuUCAFJlcG9ydCRWaWV3Q2hhcnRzJFNlbGVjdG/yAgJSZXBvcnQkVmlld0NoYXJ0cyRUZW1wb3JhbGl0+QAAAABSZXBvcnQkQ29sdW1uU3dhcFZpZfcBAAEBAAFSZXBvcnQkVGltZWxpbmVDaGFy9AEAAkNvbmNlcPQBAAFpby5pbnRpbm8uc3VtdXMubW9kZWwuUGxvdExpbuUBAAEAAAAAUGxvdExpbuUBAAEBAAGAAQACQ29uY2Vw9AEAgwEDAGxhYmXsAQCCAwCBY29sb/IBAIIDAGdyZWXuaW8uaW50aW5vLnN1bXVzLm1vZGVsLlBlcmlv5AEAAQAAAQBQZXJpb+QBAAEBAAGAAQACQ29uY2Vw9AEAggEDAGFtb3Vu9AEAggIAAmlvLmludGluby5zdW11cy5tb2RlbC5TdG9yeWJvYXLkAQCDAQIA/v///w8AU3Rvcnlib2FyZCRNZWFzdXLl/v///w8AU3Rvcnlib2FyZCREaW1lbnNpb+4AAAEAU3Rvcnlib2Fy5AEAAQEAAYABAAJDb25jZXD0AQCCAQMAaeQBAIIDALgkQGlvLmludGluby5zdW11cy5tb2RlbC5uYXRpdmVzLmFic3RyYWN0c3Rvcnlib2FyZC5JZF8wqWlvLmludGluby5zdW11cy5tb2RlbC5TdG9yeWJvYXJkJE1lYXN1cmUBAAEAAAAAU3Rvcnlib2FyZCRNZWFzdXLlAQABAQABgAEAAkNvbmNlcPQBAAGraW8uaW50aW5vLnN1bXVzLm1vZGVsLlN0b3J5Ym9hcmQkRGltZW5zaW9uAQABAAAAAFN0b3J5Ym9hcmQkRGltZW5zaW/uAQABAQABgAEAAkNvbmNlcPQBAAEBAIoBAgACAFdlZWtDYWxlbmRh8v7///8PAEJhc2VDdWLl/v///w8AUmFuZ2VCb3VuZGFy+f7///8PAERhc2hib2Fy5P7///8PAERpY3Rpb25hcvn+////DwBMZWRnZfL+////DwBSZXBvcvT+////DwBQZXJpb+T+////DwBTdG9yeWJvYXLkUHJvdGXvAQABQ2FsZW5kYXIuc3Rhc+gBAAGA";
    }

    public static class Indexer {
        Add add;
        Remove remove;
        IndexClear clear;

        public Indexer(Add add, Remove remove, IndexClear clear) {
            this.add = add;
            this.remove = remove;
            this.clear = clear;
        }

        void add(Node node) {
            this.add.add(node);
        }

        void remove(Node node) {
            this.remove.remove(node);
        }

        void clear() {
            this.clear.clear();
        }
    }

    public class Create {
        private final String stash;
        private final String name;

        public Create(String stash, String name) {
            this.stash = stash;
            this.name = name;
        }

        public WeekCalendar weekCalendar() {
            WeekCalendar newElement = (WeekCalendar)((WeekCalendar)AbstractGraph.this.graph.createRoot(WeekCalendar.class, this.stash, this.name)).a$(WeekCalendar.class);
            return newElement;
        }

        public BaseCube baseCube(Ledger ledger) {
            BaseCube newElement = (BaseCube)((BaseCube)AbstractGraph.this.graph.createRoot(BaseCube.class, this.stash, this.name)).a$(BaseCube.class);
            newElement.core$().set((Layer)newElement, "ledger", Collections.singletonList(ledger));
            return newElement;
        }

        public Dashboard dashboard(String label) {
            Dashboard newElement = (Dashboard)((Dashboard)AbstractGraph.this.graph.createRoot(Dashboard.class, this.stash, this.name)).a$(Dashboard.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        public Dictionary dictionary(String language) {
            Dictionary newElement = (Dictionary)((Dictionary)AbstractGraph.this.graph.createRoot(Dictionary.class, this.stash, this.name)).a$(Dictionary.class);
            newElement.core$().set((Layer)newElement, "language", Collections.singletonList(language));
            return newElement;
        }

        public Translatable translatable(List<Dictionary> dictionaries) {
            Translatable newElement = (Translatable)((Translatable)AbstractGraph.this.graph.createRoot(Translatable.class, this.stash, this.name)).a$(Translatable.class);
            newElement.core$().set((Layer)newElement, "dictionaries", dictionaries);
            return newElement;
        }

        public Ledger ledger(AbstractLedger.Content content) {
            Ledger newElement = (Ledger)((Ledger)AbstractGraph.this.graph.createRoot(Ledger.class, this.stash, this.name)).a$(Ledger.class);
            newElement.core$().set((Layer)newElement, "content", Collections.singletonList(content));
            return newElement;
        }

        public Report report(String label) {
            Report newElement = (Report)((Report)AbstractGraph.this.graph.createRoot(Report.class, this.stash, this.name)).a$(Report.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        public Period period(Scale unit) {
            Period newElement = (Period)((Period)AbstractGraph.this.graph.createRoot(Period.class, this.stash, this.name)).a$(Period.class);
            newElement.core$().set((Layer)newElement, "unit", Collections.singletonList(unit));
            return newElement;
        }

        public Storyboard storyboard(String label, Ledger ledger) {
            Storyboard newElement = (Storyboard)((Storyboard)AbstractGraph.this.graph.createRoot(Storyboard.class, this.stash, this.name)).a$(Storyboard.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "ledger", Collections.singletonList(ledger));
            return newElement;
        }
    }

    public class Clear {
        public void baseCube(Predicate<BaseCube> filter) {
            new ArrayList<BaseCube>(AbstractGraph.this.baseCubeList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void dashboard(Predicate<Dashboard> filter) {
            new ArrayList<Dashboard>(AbstractGraph.this.dashboardList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void dictionary(Predicate<Dictionary> filter) {
            new ArrayList<Dictionary>(AbstractGraph.this.dictionaryList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void translatable(Predicate<Translatable> filter) {
            new ArrayList<Translatable>(AbstractGraph.this.translatableList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void ledger(Predicate<Ledger> filter) {
            new ArrayList<Ledger>(AbstractGraph.this.ledgerList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void report(Predicate<Report> filter) {
            new ArrayList<Report>(AbstractGraph.this.reportList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void period(Predicate<Period> filter) {
            new ArrayList<Period>(AbstractGraph.this.periodList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void storyboard(Predicate<Storyboard> filter) {
            new ArrayList<Storyboard>(AbstractGraph.this.storyboardList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    static interface Add {
        public void add(Node var1);
    }

    static interface Remove {
        public void remove(Node var1);
    }

    static interface IndexClear {
        public void clear();
    }
}

